/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.maven.plugins.daemon;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemon;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemonRequirement;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.maven.plugins.daemon.Daemon;
import org.echocat.maven.plugins.daemon.DaemonMojoSupport;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartDaemonMojo
extends DaemonMojoSupport {
    @Parameter(property="daemon.output", defaultValue="redirectToFile|file=${project.build.directory}/logs/daemon.log|recordProcessStarted=true|recordProcessTerminated=true", required=true)
    private String output;

    @Override
    public void call() throws Exception {
        LocalProcessDaemon daemon = this.getProcessDaemonRepository().generate((LocalProcessDaemonRequirement)Daemon.Requirement.daemon(this.getExecutable()).withArguments(this.getArguments()).withStreamListener(this.getOutput()));
        this.registerPid((LocalGeneratedProcess)daemon.getProcess());
    }

    protected void registerPid(@Nonnull LocalGeneratedProcess process) throws MojoExecutionException {
        String pidProperty = this.getPidProperty();
        this.validatePidProperty(process, pidProperty);
        this.getProperties().setProperty(pidProperty, Long.toString((Long)process.getId()));
    }

    protected void validatePidProperty(@Nonnull LocalGeneratedProcess process, @Nonnull String pidProperty) throws MojoExecutionException {
        String pidValue = this.getProperties().getProperty(pidProperty);
        if (!StringUtils.isEmpty((CharSequence)pidValue)) {
            ResourceUtils.closeQuietly((AutoCloseable)process);
            throw new MojoExecutionException("The project property '" + pidProperty + "' is already set to '" + pidValue + "' this indicates double usage of this maven plugin without configuring another pid property.");
        }
    }

    @Nonnull
    protected String getOutput() throws MojoExecutionException {
        String result = this.output;
        if (result == null) {
            throw new MojoExecutionException("No output provided.");
        }
        return result;
    }
}

