/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins;

import com.android.ddmlib.IDevice;
import org.apache.maven.plugins.annotations.Mojo;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.rundroid.maven.plugins.platform.DeviceController.Environment;
import org.echocat.rundroid.maven.plugins.utils.AdbMojoSupport;

import javax.annotation.Nullable;

import static org.apache.maven.plugins.annotations.LifecyclePhase.PRE_INTEGRATION_TEST;
import static org.echocat.rundroid.maven.plugins.platform.DeviceController.Environment.deviceEnvironment;
import static org.echocat.rundroid.maven.plugins.platform.DeviceController.deviceController;

@Mojo(
    name = "rebootEmulator",
    defaultPhase = PRE_INTEGRATION_TEST
)
public class RebootEmulatorMojo extends AdbMojoSupport {

    @Override
    public void call() throws Exception {
        doWithDevices(new Consumer<IDevice, Exception>() { @Override public void consume(@Nullable IDevice device) throws Exception {
            final Environment environment = deviceEnvironment(device);
            deviceController().exec(environment, "reboot");
        }});
    }

}
