/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemon;
import org.echocat.rundroid.maven.plugins.logcat.Logcat;
import org.echocat.rundroid.maven.plugins.logcat.LogcatMojoSupport;

import javax.annotation.Nonnull;

import static org.apache.maven.plugins.annotations.LifecyclePhase.PRE_INTEGRATION_TEST;
import static org.echocat.rundroid.maven.plugins.logcat.LogcatDaemonRequirement.logcatDaemon;
import static org.echocat.rundroid.maven.plugins.utils.DeviceUtils.deviceIsMatching;

@Mojo(
    name = "startLogcat",
    defaultPhase = PRE_INTEGRATION_TEST
)
@SuppressWarnings("InstanceVariableNamingConvention")
public class StartLogcatMojo extends LogcatMojoSupport {

    @Parameter(property = "logcat.arguments")
    private String[] logcatArguments;
    @Parameter(property = "logcat.output", defaultValue = "redirectToLogger", required = true)
    private String logcatOutput;
    @Parameter(property = "logcat.logStart", defaultValue = "true")
    private boolean logLogcatStart;
    @Parameter(property = "logcat.logStartupDone", defaultValue = "true")
    private boolean logLogcatStartupDone;
    @Parameter(property = "logcat.logTermination", defaultValue = "true")
    private boolean logLogcatTermination;
    @Parameter(property = "logcat.shutdownWithMaven", defaultValue = "true")
    private boolean shutdownLogcatWithMaven;

    @Override
    public void call() throws Exception {
        if (shutdownLogcatWithMaven) {
            final Logcat logcat = new Logcat(deviceIsMatching(getDeviceSerialNumber()), getTargetAdbExecutable())
                .withArguments(getLogcatArguments())
                .withStreamListener(getLogcatOutput())
                .whichLogsStart(logLogcatStart)
                .whichLogsStartupDone(logLogcatStartupDone)
                .whichLogsTermination(logLogcatTermination)
            ;
            logcat.start();
            registerLogcat(logcat);
            registerPidOf(logcat);
        } else {
            final LocalProcessDaemon<?> daemon = processDaemonRepository().generate(logcatDaemon(getTargetAdbExecutable())
                .withArguments(getLogcatArguments())
                .withStreamListener(getLogcatOutput())
                .whichLogsStartOfProcess(logLogcatStart)
                .whichLogsStartupDoneOfProcess(logLogcatStartupDone)
                .whichLogsTerminationOfProcess(logLogcatTermination)
                .whichShuttingDownWithThisJvm(shutdownLogcatWithMaven)
            );
            registerPidOf(daemon);
        }
    }

    protected void registerPidOf(@Nonnull LocalProcessDaemon<?> daemon) throws MojoExecutionException {
        registerPid(daemon.getProcess(), getLogcatPidProperty());
    }

    protected void registerPidOf(@Nonnull Logcat logcat) throws MojoExecutionException {
        registerPid(logcat, getLogcatPidProperty());
    }

    @Nonnull
    protected String[] getLogcatArguments() throws MojoExecutionException {
        return logcatArguments;
    }

    @Nonnull
    protected String getLogcatOutput() throws MojoExecutionException {
        final String result = logcatOutput;
        if (result == null) {
            throw new MojoExecutionException("No output provided.");
        }
        return result;
    }

}
