package org.echocat.rundroid.maven.plugins;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemonRepository;
import org.echocat.rundroid.maven.plugins.emulator.EmulatorMojoSupport;

import static org.apache.maven.plugins.annotations.LifecyclePhase.POST_INTEGRATION_TEST;
import static org.echocat.rundroid.maven.plugins.emulator.EmulatorDaemonQuery.emulatorDaemon;

@Mojo(
    name = "stopEmulator",
    defaultPhase = POST_INTEGRATION_TEST
)
public class StopEmulatorMojo extends EmulatorMojoSupport {

    @Override
    public void call() throws Exception {
        final Long pid = findPidOf(getEmulatorPidProperty());
        final LocalProcessDaemonRepository repository = processDaemonRepository();
        if (pid != null) {
            repository.removeBy(pid);
        } else {
            repository.removeBy(emulatorDaemon()
                .withExecutable(getTargetEmulatorExecutable())
                .withAvd(getAvd())
            );
        }
        unregisterPid();
        unregisterSerialNumber();
    }

    protected void unregisterPid() throws MojoExecutionException {
        unregisterPid(getEmulatorPidProperty());
    }

    protected void unregisterSerialNumber() throws MojoExecutionException {
        removeProjectProperty(getEmulatorSerialNumberProperty());
    }

}
