/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.rundroid.maven.plugins.logcat.Logcat;
import org.echocat.rundroid.maven.plugins.logcat.LogcatMojoSupport;

import javax.annotation.Nonnull;
import java.util.List;

import static java.util.Arrays.asList;
import static org.apache.maven.plugins.annotations.LifecyclePhase.POST_INTEGRATION_TEST;
import static org.echocat.jomon.runtime.CollectionUtils.addAll;
import static org.echocat.jomon.runtime.util.ResourceUtils.closeQuietly;
import static org.echocat.rundroid.maven.plugins.logcat.LogcatDaemonQuery.logcatDaemon;

@Mojo(
    name = "stopLogcat",
    defaultPhase = POST_INTEGRATION_TEST
)
@SuppressWarnings("InstanceVariableNamingConvention")
public class StopLogcatMojo extends LogcatMojoSupport {

    @Parameter(property = "logcat.startsWithArguments")
    private String[] logcatStartsWithArguments;

    @Override
    public void call() throws Exception {
        final Long pid = findPidOf(getLogcatPidProperty());
        if (pid != null) {
            final Logcat logcat = findLogcat(pid);
            if (logcat != null) {
                closeQuietly(logcat);
                unregisterLogcat(logcat);
            } else {
                processDaemonRepository().removeBy(pid);
            }
        } else {
            final List<String> args = asList("logcat");
            addAll(args, getLogcatStartsWithArguments());
            processDaemonRepository().removeBy(logcatDaemon()
                .withExecutable(getTargetAdbExecutable())
                .whichStartsWithArguments(args)
            );
        }
        unregisterPid();
    }

    protected void unregisterPid() throws MojoExecutionException {
        unregisterPid(getLogcatPidProperty());
    }

    @Nonnull
    protected String[] getLogcatStartsWithArguments() throws MojoExecutionException {
        return logcatStartsWithArguments;
    }

}
