package org.echocat.rundroid.maven.plugins.emulator;

import org.echocat.jomon.process.daemon.BaseProcessDaemonQuery;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.File;

public class EmulatorDaemonQuery extends BaseProcessDaemonQuery<File, Long, EmulatorDaemonQuery, EmulatorDaemon> {

    @Nonnull
    public static EmulatorDaemonQuery emulatorDaemon() {
        return new EmulatorDaemonQuery();
    }

    @Nullable
    private String _avd;

    @Nonnull
    public EmulatorDaemonQuery withAvd(@Nonnull String avd) {
        if (_avd != null) {
            throw new IllegalStateException("avd was already defined.");
        }
        _avd = avd;
        return thisQuery();
    }

    @Nullable
    public String getAvd() {
        return _avd;
    }

    @Override
    public boolean apply(@Nullable EmulatorDaemon daemon) {
        return super.apply(daemon)
            && applyAvd(daemon)
            ;
    }

    protected boolean applyAvd(@Nonnull EmulatorDaemon daemon) {
        return _avd == null || _avd.equals(daemon.getAvd());
    }

}
