/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.logcat;

import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.LocalGeneratedProcessRequirement;
import org.echocat.jomon.process.local.LocalProcessRepository;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemon;
import org.echocat.jomon.runtime.generation.Generator;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

import static org.echocat.jomon.process.local.LocalGeneratedProcessRequirement.process;

@ThreadSafe
public class LogcatDaemon extends LocalProcessDaemon<LogcatDaemonRequirement> {

    public LogcatDaemon(@Nonnull LocalProcessRepository processRepository, @Nonnull LogcatDaemonRequirement requirement) throws CouldNotStartException {
        super(processRepository, requirement);
    }

    @Nonnull
    @Override
    protected LocalGeneratedProcess generateProcess(@Nonnull Generator<LocalGeneratedProcess, LocalGeneratedProcessRequirement> repository, @Nonnull LogcatDaemonRequirement requirement) throws Exception {
        return repository.generate(process(requirement.getAdbExecutable())
            .whichIsDaemon(requirement.isShutdownWithThisJvm())
            .withArgument("logcat")
            .withArguments(requirement.getArguments())
        );
    }

    @Override
    public String toString() {
        return "Logcat{}";
    }

}
