/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.logcat;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.rundroid.maven.plugins.utils.AdbMojoSupport;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static java.lang.Runtime.getRuntime;
import static org.echocat.jomon.runtime.util.ResourceUtils.closeQuietly;

@SuppressWarnings("InstanceVariableNamingConvention")
public abstract class LogcatMojoSupport extends AdbMojoSupport {

    @Nonnull
    private static final Map<Long, Logcat> ID_TO_LOGCAT = new ConcurrentHashMap<>();

    static {
        getRuntime().addShutdownHook(new Thread("Shutdown all left Logcats") { @Override public void run() {
            synchronized (ID_TO_LOGCAT) {
                closeQuietly(ID_TO_LOGCAT.values());
            }
        }});
    }

    @Parameter(property = "logcat.pidProperty", defaultValue = "logcat.pid")
    private String logcatPidProperty;

    @Nonnull
    protected String getLogcatPidProperty() throws MojoExecutionException {
        final String result = logcatPidProperty;
        if (result == null) {
            throw new MojoExecutionException("No logcatPidProperty set.");
        }
        return result;
    }

    protected void registerLogcat(@Nonnull Logcat logcat) throws MojoExecutionException {
        ID_TO_LOGCAT.put(logcat.getId(), logcat);
    }

    protected void unregisterLogcat(@Nonnegative Logcat logcat) throws MojoExecutionException {
        ID_TO_LOGCAT.remove(logcat.getId());
    }

    @Nonnull
    protected Logcat findLogcat(@Nonnegative long id) throws MojoExecutionException {
        return ID_TO_LOGCAT.get(id);
    }
}
