/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.utils;

import com.android.ddmlib.IDevice;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.platform.AdbController.Environment;

import javax.annotation.Nonnull;

import static org.echocat.rundroid.maven.plugins.platform.AdbController.adbController;
import static org.echocat.rundroid.maven.plugins.utils.DeviceUtils.deviceIsMatching;

@SuppressWarnings("InstanceVariableNamingConvention")
public abstract class AdbMojoSupport extends AndroidMojoSupport {

    @Parameter(property = "android.device.serialNumber")
    private String deviceSerialNumber;
    @Parameter(property = "android.device.timeout", defaultValue = "2m", required = true)
    private String deviceTimeout;
    @Parameter(property = "adb.timeout", defaultValue = "30s", required = true)
    private String adbTimeout;

    @Nonnull
    protected String getDeviceSerialNumber() throws MojoExecutionException {
        final String result = deviceSerialNumber;
        if (result == null) {
            throw new MojoExecutionException("No deviceSerialNumber set. If you call mojos of this plugin without starting a emulator by this plugin before you have to provide a deviceSerialNumber.");
        }
        return result;
    }

    @Nonnull
    protected Duration getDeviceTimeout() throws MojoExecutionException {
        return getDuration(deviceTimeout, "deviceTimeout");
    }

    @Nonnull
    protected Duration getAdbTimeout() throws MojoExecutionException {
        return getDuration(adbTimeout, "adbTimeout");
    }

    @Nonnull
    protected Environment adbEnvironment() throws MojoExecutionException {
        return new Environment(getTargetAdbExecutable())
            .acceptingBy(deviceIsMatching(getDeviceSerialNumber()))
            .withDeviceTimeout(getDeviceTimeout())
            .withAdbTimeout(getAdbTimeout())
            ;
    }

    protected void doWithDevices(@Nonnull Consumer<IDevice, Exception> consumer) throws MojoExecutionException, MojoFailureException {
        try {
            adbController().doWithDevices(adbEnvironment(), consumer);
        } catch (final MojoExecutionException | MojoFailureException e) {
            throw e;
        } catch (final Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }


}
