/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins;

import com.android.ddmlib.IDevice;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.platform.DeviceController;
import org.echocat.rundroid.maven.plugins.utils.ManifestAndAdbMojoSupport;

@Mojo(name="installApk", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class InstallApkMojo
extends ManifestAndAdbMojoSupport {
    @Parameter(property="apk", defaultValue="${project.build.directory}/${project.build.finalName}.apk", required=true)
    private File apk;
    @Parameter(property="adb.installTimeout", defaultValue="5m")
    private String installTimeout;

    public void call() throws Exception {
        final File apk = this.getApk();
        this.doWithDevices(new Consumer<IDevice, Exception>(){

            public void consume(@Nullable IDevice device) throws Exception {
                DeviceController.Environment environment = DeviceController.Environment.deviceEnvironment(device).withCommandTimeout(InstallApkMojo.this.getInstallTimeout());
                DeviceController.deviceController().installLocalFile(environment, apk, InstallApkMojo.this.getInstrumentationPackage(), true);
            }
        });
    }

    @Nonnull
    protected Duration getInstallTimeout() throws MojoExecutionException {
        return this.getDuration(this.installTimeout, "installTimeout");
    }

    @Nonnull
    protected File getApk() throws MojoExecutionException {
        File result = this.apk;
        if (result == null) {
            throw new MojoExecutionException("There is no apk specified.");
        }
        if (!result.exists()) {
            throw new MojoExecutionException("The apk '" + result + "' does not exist.");
        }
        if (!result.isFile()) {
            throw new MojoExecutionException("The apk '" + result + "' is not a file.");
        }
        try {
            return result.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("It was not possible to make apk '" + result + "' canonical.", (Exception)e);
        }
    }
}

