/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins;

import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.process.daemon.ProcessDaemonRequirement;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.rundroid.maven.plugins.emulator.EmulatorDaemon;
import org.echocat.rundroid.maven.plugins.emulator.EmulatorDaemonRequirement;
import org.echocat.rundroid.maven.plugins.emulator.EmulatorMojoSupport;

@Mojo(name="startEmulator", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartEmulatorMojo
extends EmulatorMojoSupport {
    @Parameter(property="emulator.arguments")
    private String[] emulatorArguments;
    @Parameter(property="emulator.output", defaultValue="redirectToLogger", required=true)
    private String emulatorOutput;
    @Parameter(property="emulator.logStart", defaultValue="true")
    private boolean logEmulatorStart;
    @Parameter(property="emulator.logStartupDone", defaultValue="true")
    private boolean logEmulatorStartupDone;
    @Parameter(property="emulator.logTermination", defaultValue="true")
    private boolean logEmulatorTermination;
    @Parameter(property="emulator.shutdownWithMaven", defaultValue="true")
    private boolean shutdownEmulatorWithMaven;

    public void call() throws Exception {
        EmulatorDaemon daemon = (EmulatorDaemon)this.processDaemonRepository().generate((ProcessDaemonRequirement)((EmulatorDaemonRequirement)((EmulatorDaemonRequirement)((EmulatorDaemonRequirement)((EmulatorDaemonRequirement)((EmulatorDaemonRequirement)((EmulatorDaemonRequirement)EmulatorDaemonRequirement.emulatorDaemon(this.getTargetEmulatorExecutable(), this.getAvd()).withArguments(this.getEmulatorArguments())).withStreamListener(this.getEmulatorOutput())).whichLogsStartOfProcess(this.logEmulatorStart)).whichLogsStartupDoneOfProcess(this.logEmulatorStartupDone)).whichLogsTerminationOfProcess(this.logEmulatorTermination)).whichShuttingDownWithThisJvm(this.shutdownEmulatorWithMaven)).withAdbExecutable(this.getTargetAdbExecutable()));
        this.registerPidOf(daemon);
        this.registerDeviceSerialNumberOf(daemon);
    }

    protected void registerPidOf(@Nonnull EmulatorDaemon daemon) throws MojoExecutionException {
        this.registerPid(daemon.getProcess(), this.getEmulatorPidProperty());
    }

    protected void registerDeviceSerialNumberOf(@Nonnull EmulatorDaemon daemon) throws MojoExecutionException {
        String property = this.getEmulatorSerialNumberProperty();
        this.validatePropertyForRegister(daemon, property);
        this.setProjectProperty(property, daemon.getSerialNumber());
    }

    protected void validatePropertyForRegister(@Nonnull EmulatorDaemon daemon, @Nonnull String property) throws MojoExecutionException {
        String value = this.findProjectProperty(property);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            ResourceUtils.closeQuietly((AutoCloseable)((Object)daemon));
            throw new MojoExecutionException("The project property '" + property + "' is already set to '" + value + "' this indicates double usage of this maven plugin without configuring another pid property.");
        }
    }

    @Nonnull
    protected String[] getEmulatorArguments() throws MojoExecutionException {
        String[] stringArray;
        String[] result = this.emulatorArguments;
        if (result != null && result.length > 0) {
            stringArray = result;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "-no-skin";
            stringArray = stringArray2;
            stringArray2[1] = "-no-window";
        }
        return stringArray;
    }

    @Nonnull
    protected String getEmulatorOutput() throws MojoExecutionException {
        String result = this.emulatorOutput;
        if (result == null) {
            throw new MojoExecutionException("No output provided.");
        }
        return result;
    }
}

