/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.logcat;

import java.io.File;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.ProcessUtils;
import org.echocat.jomon.process.listeners.startup.StartupListener;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.rundroid.maven.plugins.logcat.LogcatDaemon;
import org.echocat.rundroid.maven.plugins.utils.DaemonRequirementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogcatDaemonRequirement
extends DaemonRequirementSupport<LogcatDaemonRequirement, LogcatDaemon> {
    private static final Logger LOG = LoggerFactory.getLogger(LogcatDaemonRequirement.class);
    @Nonnull
    private final File _adbExecutable;

    @Nonnull
    public static LogcatDaemonRequirement logcatDaemon(@Nonnull File adbExecutable) {
        return new LogcatDaemonRequirement(adbExecutable);
    }

    public LogcatDaemonRequirement(@Nonnull File executable) {
        this._adbExecutable = executable;
    }

    @Nonnull
    public Class<LogcatDaemon> getType() {
        return LogcatDaemon.class;
    }

    @Nonnull
    public File getAdbExecutable() {
        return this._adbExecutable;
    }

    @Override
    protected void logStartOfProcess(@Nonnull LocalGeneratedProcess process) {
        LOG.info("Starting logcat: " + ProcessUtils.toEscapedCommandLine((Iterable)process.getArguments()) + "...");
    }

    @Override
    protected void logStartupDoneOfProcess(@Nonnull LocalGeneratedProcess process) {
        LOG.info("Logcat #" + process.getId() + " started successful.");
    }

    @Override
    protected void logTerminationOfProcess(@Nonnull LocalGeneratedProcess process, boolean success) {
        if (success) {
            LOG.info("Logcat #" + process.getId() + " exited successful. ExitCode: " + process.exitValue());
        } else {
            LOG.warn("Logcat #" + process.getId() + " exited with error. ExitCode: " + process.exitValue());
        }
    }

    @Nonnull
    public StartupListener<LocalGeneratedProcess> getStartupListener() {
        return StartupListener.NoopStartupListener.noop();
    }
}

