/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.platform;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.concurrent.BaseRetryingStrategy;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedTimeStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.numbers.IntegerRange;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.utils.DeviceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdbController {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AdbController.class);
    @Nonnull
    private static final AdbController INSTANCE = new AdbController();
    @Nonnull
    public static final Duration DISPLAY_COUNTDOWN_AFTER = new Duration(System.getProperty(AdbController.class.getName() + ".displayCountdownAfter", "3s"));

    @Nonnull
    public static AdbController getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static AdbController adbController() {
        return AdbController.getInstance();
    }

    public void doWithDevices(@Nonnull Environment environment, final @Nonnull Consumer<IDevice, Exception> deviceConsumer) throws InterruptedException, Exception {
        StopWatch stopWatch = new StopWatch();
        Collection<IDevice> devices = this.getDevicesFor(environment, stopWatch);
        ExecutorService threadPool = Executors.newCachedThreadPool();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (final IDevice device : devices) {
            if (!environment.matchingDevice(device)) continue;
            futures.add(threadPool.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    deviceConsumer.consume((Object)device);
                    return null;
                }
            }));
        }
        this.waitFor(futures);
    }

    protected void waitFor(@Nonnull Iterable<Future<Void>> futures) throws InterruptedException, Exception {
        for (Future<Void> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new RuntimeException("Execution produces an exception.", cause != null ? cause : e);
            }
        }
    }

    @Nonnull
    protected Collection<IDevice> getDevicesFor(@Nonnull Environment environment, @Nonnull StopWatch stopWatch) throws TimeoutException, IOException {
        AndroidDebugBridge adb = this.getAdbFor(environment);
        return this.getDevicesFor(environment, adb, this.leftDeviceTimeoutFor(environment, stopWatch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Collection<IDevice> getDevicesFor(final @Nonnull Environment environment, final @Nonnull AndroidDebugBridge adb, @Nonnull Duration timeout) throws TimeoutException, IOException {
        final StopWatch stopWatch = new StopWatch();
        BaseRetryingStrategy strategy = ((RetryForSpecifiedTimeStrategy)RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)timeout).withWaitBetweenEachTry("1s")).withResultsThatForceRetry((Object[])new Boolean[]{false});
        final AtomicReference result = new AtomicReference();
        final AtomicInteger cleanupConsoleLength = new AtomicInteger();
        try {
            Retryer.executeWithRetry((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    AdbController.this.displayDeviceCountdownIfNeeded(environment, stopWatch, cleanupConsoleLength);
                    Collection<IDevice> devices = AdbController.this.getDevicesFor(environment, adb);
                    result.set(devices);
                    return environment.matchingNumberOfDevices(devices.size());
                }
            }, (RetryingStrategy)strategy);
            if (!environment.matchingNumberOfDevices(((Collection)result.get()).size())) {
                throw new TimeoutException("Could not get device list within " + timeout + ".");
            }
        }
        finally {
            this.cleanupConsoleIfNeeded(environment, cleanupConsoleLength);
        }
        Collection devices = (Collection)result.get();
        this.logFoundDevices(devices);
        return devices;
    }

    protected void logFoundDevices(@Nonnull Collection<IDevice> devices) {
        if (devices.isEmpty()) {
            LOG.info("Found no device.");
        } else if (devices.size() == 1) {
            LOG.info("Using device: " + DeviceUtils.toString(devices.iterator().next()));
        } else {
            StringBuilder sb = new StringBuilder();
            for (IDevice device : devices) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(DeviceUtils.toString(device));
            }
            LOG.info("Using devices: " + sb.toString());
        }
    }

    @Nonnull
    protected Collection<IDevice> getDevicesFor(@Nonnull Environment environment, @Nonnull AndroidDebugBridge adb) {
        List devices = CollectionUtils.asList((Object[])adb.getDevices());
        Predicate<IDevice> predicate = environment.getDevicePredicate();
        return predicate != null ? Collections2.filter((Collection)devices, predicate) : devices;
    }

    @Nonnull
    protected AndroidDebugBridge getAdbFor(@Nonnull Environment environment) throws TimeoutException, IOException {
        StopWatch stopWatch = new StopWatch();
        AndroidDebugBridge adb = AndroidDebugBridge.createBridge((String)environment.getExecutable().getPath(), (boolean)false);
        this.waitUntilConnected(adb, environment, stopWatch);
        this.waitForInitialDeviceList(adb, environment, stopWatch);
        return adb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilConnected(final @Nonnull AndroidDebugBridge adb, final @Nonnull Environment environment, final @Nonnull StopWatch stopWatch) throws TimeoutException, IOException {
        Duration timeout = this.leftAdbTimeoutFor(environment, stopWatch);
        BaseRetryingStrategy strategy = ((RetryForSpecifiedTimeStrategy)RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)timeout).withWaitBetweenEachTry("1s")).withResultsThatForceRetry((Object[])new Boolean[]{false});
        final AtomicInteger cleanupConsoleLength = new AtomicInteger();
        try {
            Retryer.executeWithRetry((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    AdbController.this.displayAdbCountdownIfNeeded(environment, stopWatch, cleanupConsoleLength);
                    return adb.isConnected();
                }
            }, (RetryingStrategy)strategy);
            if (!adb.isConnected()) {
                throw new TimeoutException("Could not connect to ADB within " + timeout + ".");
            }
        }
        finally {
            this.cleanupConsoleIfNeeded(environment, cleanupConsoleLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForInitialDeviceList(final @Nonnull AndroidDebugBridge adb, final @Nonnull Environment environment, final @Nonnull StopWatch stopWatch) throws TimeoutException, IOException {
        Duration timeout = this.leftAdbTimeoutFor(environment, stopWatch);
        BaseRetryingStrategy strategy = ((RetryForSpecifiedTimeStrategy)RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)timeout).withWaitBetweenEachTry("1s")).withResultsThatForceRetry((Object[])new Boolean[]{false});
        final AtomicInteger cleanupConsoleLength = new AtomicInteger();
        try {
            Retryer.executeWithRetry((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    AdbController.this.displayAdbCountdownIfNeeded(environment, stopWatch, cleanupConsoleLength);
                    return adb.hasInitialDeviceList();
                }
            }, (RetryingStrategy)strategy);
            if (!adb.hasInitialDeviceList()) {
                throw new TimeoutException("Did not receive initial device list from ADB after " + timeout + ".");
            }
        }
        finally {
            this.cleanupConsoleIfNeeded(environment, cleanupConsoleLength);
        }
    }

    protected void displayDeviceCountdownIfNeeded(@Nonnull Environment environment, @Nonnull StopWatch stopWatch, @Nonnull AtomicInteger cleanupConsoleLength) throws IOException {
        Writer consumer;
        if (this.shouldDisplayCountdownFor(stopWatch) && (consumer = environment.getProgressConsumer()) != null) {
            String output = "\rWaiting for devices... " + this.leftDeviceTimeoutFor(environment, stopWatch).trim(TimeUnit.SECONDS);
            consumer.write(output);
            consumer.flush();
            cleanupConsoleLength.set(output.length());
        }
    }

    protected void displayAdbCountdownIfNeeded(@Nonnull Environment environment, @Nonnull StopWatch stopWatch, @Nonnull AtomicInteger cleanupConsoleLength) throws IOException {
        Writer consumer;
        if (this.shouldDisplayCountdownFor(stopWatch) && (consumer = environment.getProgressConsumer()) != null) {
            String output = "\rWaiting for adb... " + this.leftAdbTimeoutFor(environment, stopWatch).trim(TimeUnit.SECONDS);
            consumer.write(output);
            consumer.flush();
            cleanupConsoleLength.set(output.length());
        }
    }

    protected boolean shouldDisplayCountdownFor(@Nonnull StopWatch stopWatch) {
        return DISPLAY_COUNTDOWN_AFTER.isLessThanOrEqualTo(stopWatch.getCurrentDuration());
    }

    protected void cleanupConsoleIfNeeded(@Nonnull Environment environment, @Nonnull AtomicInteger cleanupConsoleLength) throws IOException {
        this.cleanupConsoleIfNeeded(environment, cleanupConsoleLength.get());
    }

    protected void cleanupConsoleIfNeeded(@Nonnull Environment environment, @Nonnull int cleanupConsoleLength) throws IOException {
        if (cleanupConsoleLength > 0) {
            Writer consumer = environment.getProgressConsumer();
            consumer.write(13);
            for (int i = 0; i < cleanupConsoleLength; ++i) {
                consumer.write(32);
            }
            consumer.write(13);
            consumer.flush();
        }
    }

    @Nonnull
    protected Duration leftAdbTimeoutFor(@Nonnull Environment environment, @Nonnull StopWatch stopWatch) {
        return environment.getAdbTimeout().minus(stopWatch.getCurrentDuration());
    }

    @Nonnull
    protected Duration leftDeviceTimeoutFor(@Nonnull Environment environment, @Nonnull StopWatch stopWatch) {
        return environment.getDeviceTimeout().minus(stopWatch.getCurrentDuration());
    }

    static {
        AndroidDebugBridge.init((boolean)false);
    }

    public static class AdbException
    extends RuntimeException {
        public AdbException(String message) {
            super(message);
        }

        public AdbException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Environment {
        @Nonnull
        private final File _executable;
        @Nullable
        private Writer _progressConsumer = new OutputStreamWriter(System.out);
        @Nullable
        private Predicate<IDevice> _devicePredicate;
        @Nullable
        private Predicate<Integer> _expectedNumberOfDevices = new IntegerRange(Integer.valueOf(1), null);
        @Nonnull
        private Duration _adbTimeout = new Duration("30s");
        @Nonnull
        private Duration _deviceTimeout = new Duration("60s");

        @Nonnull
        public static Environment adbEnvironment(@Nonnull File executable) {
            return new Environment(executable);
        }

        public Environment(@Nonnull File executable) {
            this._executable = executable;
        }

        @Nonnull
        public Environment acceptingBy(@Nonnull Predicate<IDevice> predicate) {
            this._devicePredicate = predicate;
            return this;
        }

        @Nonnull
        public Environment expectedNumberOfDevices(@Nonnull Predicate<Integer> predicate) {
            this._expectedNumberOfDevices = predicate;
            return this;
        }

        @Nonnull
        public Environment expectingMinimumNumberOfDevicesIs(int numberOfExpectedDevices) {
            return this.expectedNumberOfDevices((Predicate<Integer>)new IntegerRange(Integer.valueOf(numberOfExpectedDevices), null));
        }

        @Nonnull
        public Environment expectingMinimumOneDevice() {
            return this.expectingMinimumNumberOfDevicesIs(1);
        }

        @Nonnull
        public Environment withAdbTimeout(@Nonnull Duration timeout) {
            this._adbTimeout = timeout;
            return this;
        }

        @Nonnull
        public Environment withAdbTimeout(@Nonnull String timeout) {
            return this.withAdbTimeout(new Duration(timeout));
        }

        @Nonnull
        public Environment withDeviceTimeout(@Nonnull Duration timeout) {
            this._deviceTimeout = timeout;
            return this;
        }

        @Nonnull
        public Environment withDeviceTimeout(@Nonnull String timeout) {
            return this.withDeviceTimeout(new Duration(timeout));
        }

        @Nonnull
        public Environment withProgressConsumer(@Nullable @WillNotClose OutputStream os) {
            return this.withProgressConsumer(os != null ? new OutputStreamWriter(os) : null);
        }

        @Nonnull
        public Environment withProgressConsumer(@Nullable @WillNotClose Writer writer) {
            this._progressConsumer = writer;
            return this;
        }

        @Nonnull
        public File getExecutable() {
            return this._executable;
        }

        @Nullable
        public Predicate<IDevice> getDevicePredicate() {
            return this._devicePredicate;
        }

        @Nullable
        public Predicate<Integer> getExpectedNumberOfDevices() {
            return this._expectedNumberOfDevices;
        }

        @Nonnull
        public Duration getAdbTimeout() {
            return this._adbTimeout;
        }

        @Nonnull
        public Duration getDeviceTimeout() {
            return this._deviceTimeout;
        }

        @Nullable
        @WillNotClose
        public Writer getProgressConsumer() {
            return this._progressConsumer;
        }

        protected boolean matchingNumberOfDevices(int numberOfDevices) {
            Predicate<Integer> predicate = this._expectedNumberOfDevices;
            return predicate == null || predicate.apply((Object)numberOfDevices);
        }

        protected boolean matchingDevice(@Nullable IDevice device) {
            Predicate<IDevice> predicate;
            boolean result = device == null ? false : (predicate = this._devicePredicate) == null || predicate.apply((Object)device);
            return result;
        }
    }
}

