/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.platform;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.commons.io.FilenameUtils;
import org.echocat.jomon.runtime.concurrent.BaseRetryingStrategy;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedTimeStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceController {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DeviceController.class);
    @Nonnull
    private static final DeviceController INSTANCE = new DeviceController();
    @Nonnull
    public static final Duration DISPLAY_COUNTDOWN_AFTER = new Duration(System.getProperty(DeviceController.class.getName() + ".displayCountdownAfter", "3s"));

    @Nonnull
    public static DeviceController getInstance() {
        return INSTANCE;
    }

    @Nonnull
    public static DeviceController deviceController() {
        return DeviceController.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferLocalFile(@Nonnull Environment environment, @Nonnull File localFile, @Nonnull String remoteFile) throws IOException, TimeoutException, SyncException {
        block6: {
            try {
                IDevice device = environment.getDevice();
                SyncService sync = device.getSyncService();
                if (sync != null) {
                    try {
                        sync.pushFile(localFile.getPath(), remoteFile, (SyncService.ISyncProgressMonitor)this.getSyncProgressMonitor(environment, localFile.getPath()));
                        break block6;
                    }
                    finally {
                        sync.close();
                    }
                }
                throw new SyncException(SyncException.SyncError.CANCELED, "Unable to open sync connection.");
            }
            catch (AdbCommandRejectedException e) {
                throw new SyncException(SyncException.SyncError.CANCELED, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installLocalFile(@Nonnull Environment environment, @Nonnull File localFile, @Nonnull String packageName, boolean reinstall) throws IOException, SyncException, InstallException, TimeoutException {
        String remoteFile = "/data/local/tmp/" + UUID.randomUUID() + "." + FilenameUtils.getExtension((String)localFile.getName());
        try {
            this.transferLocalFile(environment, localFile, remoteFile);
            this.installRemoteFile(environment, remoteFile, localFile.getName(), packageName, reinstall);
        }
        finally {
            try {
                this.deleteRemoveFile(environment, remoteFile);
            }
            catch (Exception exception) {}
        }
    }

    public void installRemoteFile(@Nonnull Environment environment, @Nonnull String remoteFile, @Nonnull String packageName, boolean reinstall) throws InstallException, TimeoutException, IOException {
        this.installRemoteFile(environment, remoteFile, remoteFile, packageName, reinstall);
    }

    @Nullable
    protected <T> T executeWithRetry(final @Nonnull Environment environment, final @Nonnull Callable<T> what, final @Nonnull String messageIfTakingTooLong, final @Nonnull AtomicInteger writtenToConsole, Class<? extends Exception> ... exceptionsThatForceRetry) throws Exception {
        final StopWatch stopWatch = new StopWatch();
        BaseRetryingStrategy strategy = ((RetryForSpecifiedTimeStrategy)RetryForSpecifiedTimeStrategy.retryForSpecifiedTimeOf((Duration)environment.getCommandTimeout()).withWaitBetweenEachTry("1s")).withExceptionsThatForceRetry((Class[])exceptionsThatForceRetry);
        return (T)Retryer.executeWithRetry((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                DeviceController.this.displayCountdownIfNeeded(environment, stopWatch, writtenToConsole, messageIfTakingTooLong);
                return what.call();
            }
        }, (RetryingStrategy)strategy, Exception.class);
    }

    @Nullable
    protected <T> T executePackageMangerActionWithRetry(@Nonnull Environment environment, @Nonnull Callable<T> what, @Nonnull AtomicInteger writtenToConsole) throws Exception {
        return this.executeWithRetry(environment, what, "Waiting for Package Manager...", writtenToConsole, PackageManagerNotReadyException.class);
    }

    protected void installRemoteFile(final @Nonnull Environment environment, final @Nonnull String remoteFile, @Nonnull String fileDisplay, final @Nonnull String packageName, final boolean reinstall) throws InstallException, TimeoutException, IOException {
        IDevice device = environment.getDevice();
        AtomicInteger writtenToConsole = new AtomicInteger();
        DeviceController.write(environment, writtenToConsole, "\rInstalling " + fileDisplay + " on " + device.getSerialNumber() + "...");
        try {
            this.executePackageMangerActionWithRetry(environment, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DeviceController.this.installRemoteFileUnchecked(environment, remoteFile, packageName, reinstall);
                    return null;
                }
            }, writtenToConsole);
        }
        catch (InstallException | TimeoutException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException("Could not install " + remoteFile + " to " + device.getSerialNumber() + ". Got: " + e.getMessage(), (Throwable)e);
        }
        finally {
            DeviceController.cleanupConsoleIfNeeded(environment, writtenToConsole);
        }
        LOG.info("Installed " + fileDisplay + " on " + device.getSerialNumber() + ".");
    }

    protected void installRemoteFileUnchecked(@Nonnull Environment environment, @Nonnull String remoteFile, @Nonnull String packageName, boolean reinstall) throws TimeoutException, IOException, InstallException {
        IDevice device = environment.getDevice();
        InstallReceiver receiver = this.getInstallReceiver(environment);
        if (reinstall && this.containsPackage(environment, packageName)) {
            this.uninstallPackage(environment, packageName);
        }
        try {
            this.exec(environment, "pm install " + (reinstall ? " -r " : "") + "\"" + remoteFile + "\"", (IShellOutputReceiver)receiver);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException e) {
            throw new InstallException("Could not install " + remoteFile + " to " + device.getSerialNumber() + ". Got: " + e.getCause(), e);
        }
        if (!receiver.wasSuccessful()) {
            String output = receiver.getOutput();
            if (this.containsPackageManagerNotReady(output)) {
                throw new PackageManagerNotReadyException("Could not install " + remoteFile + " to " + device.getSerialNumber() + ". Got: " + output);
            }
            throw new InstallException("Could not install " + remoteFile + " to " + device.getSerialNumber() + ". Got: " + output, null);
        }
    }

    protected boolean containsPackageManagerNotReady(@Nullable String output) {
        return output != null && output.toLowerCase().contains("could not access the package manager");
    }

    public boolean containsPackage(final @Nonnull Environment environment, final @Nonnull String packageName) throws TimeoutException, InstallException, IOException {
        AtomicInteger writtenToConsole = new AtomicInteger();
        try {
            boolean bl = this.executePackageMangerActionWithRetry(environment, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DeviceController.this.containsPackageUnchecked(environment, packageName);
                }
            }, writtenToConsole);
            return bl;
        }
        catch (InstallException | TimeoutException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException("Could not test if package " + packageName + " is installed on " + environment.getDevice().getSerialNumber() + ". Got: " + e.getMessage(), (Throwable)e);
        }
        finally {
            DeviceController.cleanupConsoleIfNeeded(environment, writtenToConsole);
        }
    }

    protected boolean containsPackageUnchecked(Environment environment, String packageName) throws TimeoutException, IOException, InstallException {
        boolean result;
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            this.exec(environment, "pm path \"" + packageName + "\"", (IShellOutputReceiver)receiver);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException e) {
            throw new InstallException("Could not test if package " + packageName + " is installed on " + environment.getDevice().getSerialNumber() + ". Got: " + e.getCause(), e);
        }
        String output = receiver.getOutput().trim();
        if (output.isEmpty()) {
            result = false;
        } else if (output.toLowerCase().startsWith("package:")) {
            result = true;
        } else {
            if (this.containsPackageManagerNotReady(output)) {
                throw new PackageManagerNotReadyException("Could not test if package " + packageName + " is installed on " + environment.getDevice().getSerialNumber() + ". Got: " + output);
            }
            throw new InstallException("Could not test if package " + packageName + " is installed on " + environment.getDevice().getSerialNumber() + ". Got: " + output, null);
        }
        return result;
    }

    public void uninstallPackage(final @Nonnull Environment environment, final @Nonnull String packageName) throws TimeoutException, InstallException, IOException {
        AtomicInteger writtenToConsole = new AtomicInteger();
        try {
            this.executePackageMangerActionWithRetry(environment, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DeviceController.this.uninstallPackageUnchecked(environment, packageName);
                    return null;
                }
            }, writtenToConsole);
        }
        catch (InstallException | TimeoutException | IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException("Could not uninstall " + packageName + " from " + environment.getDevice().getSerialNumber() + ". Got: " + e.getCause(), (Throwable)e);
        }
        finally {
            DeviceController.cleanupConsoleIfNeeded(environment, writtenToConsole);
        }
    }

    protected void uninstallPackageUnchecked(@Nonnull Environment environment, @Nonnull String packageName) throws TimeoutException, IOException, InstallException {
        InstallReceiver receiver = this.getInstallReceiver(environment);
        try {
            this.exec(environment, "pm uninstall \"" + packageName + "\"", (IShellOutputReceiver)receiver);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException e) {
            throw new InstallException("Could not uninstall " + packageName + " from " + environment.getDevice().getSerialNumber() + ". Got: " + e.getCause(), e);
        }
        if (!receiver.wasSuccessful()) {
            String output = receiver.getOutput();
            if (this.containsPackageManagerNotReady(output)) {
                throw new PackageManagerNotReadyException("Could not uninstall " + packageName + " from " + environment.getDevice().getSerialNumber() + ". Got: " + output);
            }
            throw new InstallException("Could not uninstall " + packageName + " from " + environment.getDevice().getSerialNumber() + ". Got: " + output, null);
        }
    }

    public void exec(@Nonnull Environment environment, @Nonnull String command, @Nullable IShellOutputReceiver receiver) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        IDevice device = environment.getDevice();
        Duration timeout = environment.getCommandTimeout();
        device.executeShellCommand(command, receiver != null ? receiver : this.getDefaultShellOutputReceiver(environment), timeout != null ? timeout.in(TimeUnit.MILLISECONDS) : 0L, TimeUnit.MILLISECONDS);
    }

    public void exec(@Nonnull Environment environment, @Nonnull String command) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.exec(environment, command, null);
    }

    public void deleteRemoveFile(@Nonnull Environment environment, @Nonnull String remoteFilePath) throws SyncException, TimeoutException, IOException {
        try {
            this.exec(environment, "rm \"" + remoteFilePath + "\"");
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException e) {
            throw new SyncException(SyncException.SyncError.CANCELED, e);
        }
    }

    protected static void write(@Nonnull Environment environment, @Nonnull AtomicInteger writtenToConsole, @Nonnull String message) throws IOException {
        Writer out = environment.getProgressConsumer();
        if (out != null && LOG.isInfoEnabled()) {
            out.write(13);
            out.write(message);
            out.flush();
            int diff = writtenToConsole.get() - message.length();
            for (int i = 0; i < diff; ++i) {
                out.write(32);
            }
            writtenToConsole.set(message.length());
        }
    }

    protected static void cleanupConsoleIfNeeded(@Nonnull Environment environment, @Nonnull AtomicInteger writtenToConsole) throws IOException {
        DeviceController.write(environment, writtenToConsole, "");
        Writer out = environment.getProgressConsumer();
        if (out != null && LOG.isInfoEnabled()) {
            out.write(13);
        }
    }

    protected void displayCountdownIfNeeded(@Nonnull Environment environment, @Nonnull StopWatch stopWatch, @Nonnull AtomicInteger cleanupConsoleLength, @Nonnull String message) throws IOException {
        Writer consumer;
        if (this.shouldDisplayCountdownFor(stopWatch) && (consumer = environment.getProgressConsumer()) != null) {
            String output = "\r" + message + " " + this.leftCommandTimeoutFor(environment, stopWatch).trim(TimeUnit.SECONDS);
            consumer.write(output);
            consumer.flush();
            cleanupConsoleLength.set(output.length());
        }
    }

    @Nonnull
    protected Duration leftCommandTimeoutFor(@Nonnull Environment environment, @Nonnull StopWatch stopWatch) {
        return environment.getCommandTimeout().minus(stopWatch.getCurrentDuration());
    }

    protected boolean shouldDisplayCountdownFor(@Nonnull StopWatch stopWatch) {
        return DISPLAY_COUNTDOWN_AFTER.isLessThanOrEqualTo(stopWatch.getCurrentDuration());
    }

    @Nonnull
    protected SyncProgressMonitorImpl getSyncProgressMonitor(@Nonnull Environment environment, @Nonnull String from) {
        return new SyncProgressMonitorImpl(environment, from);
    }

    @Nonnull
    protected IShellOutputReceiver getDefaultShellOutputReceiver(@Nonnull Environment environment) {
        return new RedirectToLogShellOutputReceiver();
    }

    @Nonnull
    protected InstallReceiver getInstallReceiver(@Nonnull Environment environment) {
        return new InstallReceiver();
    }

    public static class PackageManagerNotReadyException
    extends InstallException {
        public PackageManagerNotReadyException(String message) {
            super(message, null);
        }
    }

    public static class Environment {
        @Nonnull
        private final IDevice _device;
        @Nullable
        private Writer _progressConsumer = new OutputStreamWriter(System.out);
        @Nullable
        private Duration _commandTimeout = new Duration("2m");

        @Nonnull
        public static Environment deviceEnvironment(@Nonnull IDevice device) {
            return new Environment(device);
        }

        public Environment(@Nonnull IDevice device) {
            this._device = device;
        }

        @Nonnull
        public Environment withCommandTimeout(@Nullable Duration timeout) {
            this._commandTimeout = timeout;
            return this;
        }

        @Nonnull
        public Environment withCommandTimeout(@Nullable String timeout) {
            return this.withCommandTimeout(timeout != null ? new Duration(timeout) : null);
        }

        @Nonnull
        public Environment withoutCommandTimeout() {
            return this.withCommandTimeout((Duration)null);
        }

        @Nonnull
        public Environment withProgressConsumer(@Nullable @WillNotClose OutputStream os) {
            return this.withProgressConsumer(os != null ? new OutputStreamWriter(os) : null);
        }

        @Nonnull
        public Environment withProgressConsumer(@Nullable @WillNotClose Writer writer) {
            this._progressConsumer = writer;
            return this;
        }

        @Nonnull
        public IDevice getDevice() {
            return this._device;
        }

        @Nullable
        public Duration getCommandTimeout() {
            return this._commandTimeout;
        }

        @Nullable
        @WillNotClose
        public Writer getProgressConsumer() {
            return this._progressConsumer;
        }
    }

    protected static class InstallReceiver
    extends CollectingOutputReceiver {
        @Nonnull
        protected static final Pattern SUCCESS_OUTPUT = Pattern.compile("^\\s*success", 8);
        @Nonnull
        protected static final String PKG_OUTPUT = "pkg:";
        @Nonnull
        protected static final String ERROR_OUTPUT = "error";
        @Nonnull
        protected static final String FAIL_OUTPUT = "fail";

        protected InstallReceiver() {
        }

        public boolean wasSuccessful() {
            String output = this.getOutput().toLowerCase().trim();
            boolean result = SUCCESS_OUTPUT.matcher(output).find() ? true : (output.contains(PKG_OUTPUT) ? !output.contains(ERROR_OUTPUT) && !output.contains(FAIL_OUTPUT) : false);
            return result;
        }
    }

    protected static class SyncProgressMonitorImpl
    implements SyncService.ISyncProgressMonitor {
        @Nonnull
        protected static final MessageFormat PROGRESS_START_FORMAT = new MessageFormat("Transferring {0} to {1}...", Locale.US);
        @Nonnull
        protected static final MessageFormat PROGRESS_FORMAT = new MessageFormat("Transferring {0} to {1}... {2,number,#.0}%", Locale.US);
        @Nonnull
        protected static final MessageFormat PROGRESS_DONE_FORMAT = new MessageFormat("Transferred {0} to {1}.", Locale.US);
        @Nonnull
        private final AtomicInteger _writtenToConsole = new AtomicInteger();
        @Nonnull
        private final Environment _environment;
        @Nonnull
        private final String _deviceString;
        @Nonnull
        private final String _from;
        @Nonnegative
        private int _totalWork;
        @Nonnegative
        private int _currentWork;

        public SyncProgressMonitorImpl(@Nonnull Environment environment, @Nonnull String from) {
            this._environment = environment;
            this._deviceString = this.getDeviceStringFor(environment.getDevice());
            this._from = from;
        }

        public void start(int totalWork) {
            this._totalWork = totalWork;
            String message = PROGRESS_START_FORMAT.format(new Object[]{this._from, this._deviceString});
            try {
                DeviceController.write(this._environment, this._writtenToConsole, message);
            }
            catch (IOException e) {
                LOG.warn("Could not log output: " + message, (Throwable)e);
            }
        }

        public void stop() {
            try {
                DeviceController.cleanupConsoleIfNeeded(this._environment, this._writtenToConsole);
            }
            catch (IOException e) {
                LOG.warn("Could not clear output.", (Throwable)e);
            }
            LOG.info(PROGRESS_DONE_FORMAT.format(new Object[]{this._from, this._deviceString}));
        }

        public void advance(@Nonnegative int work) {
            this._currentWork += work;
            float plainProgress = (float)this._currentWork * 100.0f / (float)this._totalWork;
            float progress = plainProgress < 100.0f ? plainProgress : 100.0f;
            String message = PROGRESS_FORMAT.format(new Object[]{this._from, this._deviceString, Float.valueOf(progress)});
            try {
                DeviceController.write(this._environment, this._writtenToConsole, message);
            }
            catch (IOException e) {
                LOG.debug("Could not log output: " + message, (Throwable)e);
            }
        }

        @Nonnull
        protected String getDeviceStringFor(@Nonnull IDevice device) {
            return device.getSerialNumber();
        }

        @Nonnegative
        protected int getTotalWork() {
            return this._totalWork;
        }

        public void startSubTask(String name) {
        }

        public boolean isCanceled() {
            return false;
        }
    }

    @Nonnull
    protected static class RedirectToLogShellOutputReceiver
    extends MultiLineReceiver {
        protected RedirectToLogShellOutputReceiver() {
        }

        public void processNewLines(String[] lines) {
            if (lines != null) {
                for (String line : lines) {
                    LOG.info(line);
                }
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }
}

