/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.platform;

import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.CollectionUtils;

public class TestRunResult {
    @Nonnull
    private final String _testRunName;
    @Nonnull
    private final Map<TestIdentifier, TestResult> _testResults = Collections.synchronizedMap(new LinkedHashMap());
    @Nonnull
    private final Map<String, String> _runMetrics = new HashMap<String, String>();
    private boolean _isRunComplete;
    private long _elapsedTime;
    private int _numberOfFailedTests;
    private int _numberOfErrorTests;
    private int _numberOfPassedTests;
    private int _numberOfInCompleteTests;
    private String _runFailureError;

    public TestRunResult(@Nonnull String runName) {
        this._testRunName = runName;
    }

    public TestRunResult() {
        this("not started");
    }

    @Nonnull
    public String getName() {
        return this._testRunName;
    }

    @Nonnull
    public Map<TestIdentifier, TestResult> getTestResults() {
        return CollectionUtils.asImmutableMap(this._testResults);
    }

    public void addMetrics(@Nullable Map<String, String> runMetrics, boolean aggregateMetrics) {
        if (runMetrics != null) {
            if (aggregateMetrics) {
                for (Map.Entry<String, String> entry : runMetrics.entrySet()) {
                    String existingValue = this._runMetrics.get(entry.getKey());
                    String combinedValue = this.combineValues(existingValue, entry.getValue());
                    this._runMetrics.put(entry.getKey(), combinedValue);
                }
            } else {
                this._runMetrics.putAll(runMetrics);
            }
        }
    }

    @Nullable
    private String combineValues(@Nullable String existingValue, @Nullable String newValue) {
        String result;
        if (existingValue != null) {
            try {
                Long existingLong = Long.parseLong(existingValue);
                Long newLong = Long.parseLong(newValue);
                result = Long.toString(existingLong + newLong);
            }
            catch (NumberFormatException ignored) {
                try {
                    Double existingDouble = Double.parseDouble(existingValue);
                    Double newDouble = Double.parseDouble(newValue);
                    result = Double.toString(existingDouble + newDouble);
                }
                catch (NumberFormatException ignored2) {
                    result = newValue;
                }
            }
        } else {
            result = newValue;
        }
        return result;
    }

    @Nonnull
    public Map<String, String> getRunMetrics() {
        return CollectionUtils.asImmutableMap(this._runMetrics);
    }

    @Nonnull
    public Set<TestIdentifier> getCompletedTests() {
        LinkedHashSet<TestIdentifier> completedTests = new LinkedHashSet<TestIdentifier>();
        for (Map.Entry<TestIdentifier, TestResult> testEntry : this.getTestResults().entrySet()) {
            if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) continue;
            completedTests.add(testEntry.getKey());
        }
        return CollectionUtils.asImmutableSet(completedTests);
    }

    public boolean isRunFailure() {
        return this._runFailureError != null;
    }

    public boolean isRunComplete() {
        return this._isRunComplete;
    }

    void setRunComplete(boolean runComplete) {
        this._isRunComplete = runComplete;
    }

    void addElapsedTime(long elapsedTime) {
        this._elapsedTime += elapsedTime;
    }

    void setRunFailureError(@Nullable String errorMessage) {
        this._runFailureError = errorMessage;
    }

    @Nonnegative
    public int getNumberOfPassedTests() {
        return this._numberOfPassedTests;
    }

    @Nonnegative
    public int getNumTests() {
        return this._testResults.size();
    }

    @Nonnegative
    public int getNumCompleteTests() {
        return this.getNumTests() - this.getNumIncompleteTests();
    }

    @Nonnegative
    public int getNumberOfFailedTests() {
        return this._numberOfFailedTests;
    }

    @Nonnegative
    public int getNumberOfErrorTests() {
        return this._numberOfErrorTests;
    }

    @Nonnegative
    public int getNumIncompleteTests() {
        return this._numberOfInCompleteTests;
    }

    public boolean hasFailedTests() {
        return this.getNumberOfErrorTests() > 0 || this.getNumberOfFailedTests() > 0;
    }

    @Nonnegative
    public long getElapsedTime() {
        return this._elapsedTime;
    }

    @Nullable
    public String getRunFailureMessage() {
        return this._runFailureError;
    }

    void reportTestStarted(@Nonnull TestIdentifier test) {
        TestResult result = this._testResults.get(test);
        if (result != null) {
            TestResult.TestStatus i = result.getStatus();
            if (i == TestResult.TestStatus.ERROR) {
                --this._numberOfErrorTests;
            } else if (i == TestResult.TestStatus.FAILURE) {
                --this._numberOfFailedTests;
            } else if (i == TestResult.TestStatus.PASSED) {
                --this._numberOfPassedTests;
            }
        } else {
            ++this._numberOfInCompleteTests;
        }
        this._testResults.put(test, new TestResult());
    }

    void reportTestFailure(@Nonnull TestIdentifier test, @Nonnull TestResult.TestStatus status, @Nullable String trace) {
        TestResult result = this._testResults.get(test);
        if (result == null) {
            result = new TestResult();
            this._testResults.put(test, result);
        } else if (result.getStatus().equals((Object)TestResult.TestStatus.PASSED)) {
            --this._numberOfPassedTests;
        }
        result.setStackTrace(trace);
        if (status == TestResult.TestStatus.ERROR) {
            ++this._numberOfErrorTests;
            result.setStatus(TestResult.TestStatus.ERROR);
        } else if (status == TestResult.TestStatus.FAILURE) {
            result.setStatus(TestResult.TestStatus.FAILURE);
            ++this._numberOfFailedTests;
        }
    }

    boolean reportTestEnded(@Nonnull TestIdentifier test, @Nullable Map<String, String> testMetrics) {
        boolean success;
        TestResult result = this._testResults.get(test);
        if (result == null) {
            result = new TestResult();
            this._testResults.put(test, result);
        } else {
            --this._numberOfInCompleteTests;
        }
        result.setEndTime(System.currentTimeMillis());
        result.setMetrics(testMetrics);
        if (result.getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) {
            result.setStatus(TestResult.TestStatus.PASSED);
            ++this._numberOfPassedTests;
            success = true;
        } else {
            success = false;
        }
        return success;
    }
}

