/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.platform;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.echocat.rundroid.maven.plugins.platform.TestRunResult;
import org.echocat.rundroid.maven.plugins.utils.DeviceUtils;
import org.echocat.rundroid.maven.plugins.utils.IdentifierUtils;
import org.kxml2.io.KXmlSerializer;

public class XmlTestRunListener
implements ITestRunListener {
    private static final String TEST_RESULT_FILE_SUFFIX = ".xml";
    private static final String TEST_RESULT_FILE_PREFIX = "TEST-";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private static final String NS = null;
    @Nonnull
    private final IDevice _device;
    @Nonnull
    private final File _reportDirectory;
    @Nonnull
    private TestRunResult _testRunResult = new TestRunResult();

    public XmlTestRunListener(@Nonnull IDevice device, @Nonnull File reportDirectory) {
        this._device = device;
        this._reportDirectory = reportDirectory;
    }

    public void testRunStarted(String runName, int numTests) {
        this._testRunResult = new TestRunResult(runName);
    }

    public void testStarted(TestIdentifier test) {
        this._testRunResult.reportTestStarted(test);
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        if (status.equals((Object)ITestRunListener.TestFailure.ERROR)) {
            this._testRunResult.reportTestFailure(test, TestResult.TestStatus.ERROR, trace);
        } else {
            this._testRunResult.reportTestFailure(test, TestResult.TestStatus.FAILURE, trace);
        }
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        this._testRunResult.reportTestEnded(test, testMetrics);
    }

    public void testRunFailed(String errorMessage) {
        this._testRunResult.setRunFailureError(errorMessage);
    }

    public void testRunStopped(long arg0) {
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        this._testRunResult.setRunComplete(true);
        try {
            this.generateDocument(elapsedTime, this._testRunResult, this._reportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write document. Got: " + e.getMessage(), e);
        }
    }

    private void generateDocument(@Nonnegative long elapsedTime, @Nonnull TestRunResult testRunResult, @Nonnull File reportDirectory) throws IOException {
        try (OutputStream stream = this.createOutputResultStream(reportDirectory, testRunResult);){
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput(stream, "UTF-8");
            serializer.startDocument("UTF-8", null);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.printTestResults(serializer, elapsedTime, testRunResult);
            serializer.endDocument();
        }
    }

    @Nonnull
    protected String getCurrentTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.getDefault());
        TimeZone gmt = TimeZone.getTimeZone("UTC");
        dateFormat.setTimeZone(gmt);
        dateFormat.setLenient(true);
        String timestamp = dateFormat.format(new Date());
        return timestamp;
    }

    @Nonnull
    protected File getResultFile(@Nonnull File reportDir, @Nonnull TestRunResult testRunResult) throws IOException {
        return new File(reportDir, TEST_RESULT_FILE_PREFIX + IdentifierUtils.normalize(testRunResult.getName()) + TEST_RESULT_FILE_SUFFIX);
    }

    @Nonnull
    protected OutputStream createOutputResultStream(@Nonnull File reportDir, @Nonnull TestRunResult testRunResult) throws IOException {
        File reportFile = this.getResultFile(reportDir, testRunResult);
        return new FileOutputStream(reportFile);
    }

    protected void printTestResults(@Nonnull KXmlSerializer serializer, @Nonnegative long elapsedTime, @Nonnull TestRunResult testRunResult) throws IOException {
        serializer.startTag(NS, TESTSUITE);
        String name = testRunResult.getName();
        if (name != null) {
            serializer.attribute(NS, ATTR_NAME, name);
        }
        serializer.attribute(NS, ATTR_TESTS, Integer.toString(testRunResult.getNumTests()));
        serializer.attribute(NS, ATTR_FAILURES, Integer.toString(testRunResult.getNumberOfFailedTests()));
        serializer.attribute(NS, ATTR_ERRORS, Integer.toString(testRunResult.getNumberOfErrorTests()));
        serializer.attribute(NS, ATTR_TIME, Double.toString((double)elapsedTime / 1000.0));
        serializer.attribute(NS, TIMESTAMP, this.getCurrentTimestamp());
        serializer.attribute(NS, HOSTNAME, DeviceUtils.toString(this._device));
        serializer.startTag(NS, PROPERTIES);
        for (Map.Entry entry : new TreeMap(this._device.getProperties()).entrySet()) {
            serializer.startTag(NS, PROPERTY);
            serializer.attribute(NS, ATTR_NAME, (String)entry.getKey());
            serializer.attribute(NS, ATTR_VALUE, (String)entry.getValue());
            serializer.endTag(NS, PROPERTY);
        }
        serializer.endTag(NS, PROPERTIES);
        Map<TestIdentifier, TestResult> testResults = testRunResult.getTestResults();
        for (Map.Entry<TestIdentifier, TestResult> testEntry : testResults.entrySet()) {
            this.print(serializer, testEntry.getKey(), testEntry.getValue());
        }
        serializer.endTag(NS, TESTSUITE);
    }

    protected void print(@Nonnull KXmlSerializer serializer, @Nonnull TestIdentifier testId, @Nonnull TestResult testResult) throws IOException {
        serializer.startTag(NS, TESTCASE);
        serializer.attribute(NS, ATTR_NAME, testId.getTestName());
        serializer.attribute(NS, ATTR_CLASSNAME, testId.getClassName());
        long elapsedTimeMs = testResult.getEndTime() - testResult.getStartTime();
        serializer.attribute(NS, ATTR_TIME, Double.toString((double)elapsedTimeMs / 1000.0));
        if (!TestResult.TestStatus.PASSED.equals((Object)testResult.getStatus())) {
            String result = testResult.getStatus().equals((Object)TestResult.TestStatus.FAILURE) ? FAILURE : ERROR;
            serializer.startTag(NS, result);
            String stackText = this.sanitize(testResult.getStackTrace());
            serializer.text(stackText);
            serializer.endTag(NS, result);
        }
        serializer.endTag(NS, TESTCASE);
    }

    @Nonnull
    protected String sanitize(@Nonnull String text) {
        return text.replace("\u0000", "<\\0>");
    }
}

