/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.utils;

import com.android.ddmlib.IDevice;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.platform.AdbController;
import org.echocat.rundroid.maven.plugins.utils.AndroidMojoSupport;
import org.echocat.rundroid.maven.plugins.utils.DeviceUtils;

public abstract class AdbMojoSupport
extends AndroidMojoSupport {
    @Parameter(property="android.device.serialNumber")
    private String deviceSerialNumber;
    @Parameter(property="android.device.timeout", defaultValue="2m", required=true)
    private String deviceTimeout;
    @Parameter(property="adb.timeout", defaultValue="30s", required=true)
    private String adbTimeout;

    @Nonnull
    protected String getDeviceSerialNumber() throws MojoExecutionException {
        String result = this.deviceSerialNumber;
        if (result == null) {
            throw new MojoExecutionException("No deviceSerialNumber set. If you call mojos of this plugin without starting a emulator by this plugin before you have to provide a deviceSerialNumber.");
        }
        return result;
    }

    @Nonnull
    protected Duration getDeviceTimeout() throws MojoExecutionException {
        return this.getDuration(this.deviceTimeout, "deviceTimeout");
    }

    @Nonnull
    protected Duration getAdbTimeout() throws MojoExecutionException {
        return this.getDuration(this.adbTimeout, "adbTimeout");
    }

    @Nonnull
    protected AdbController.Environment adbEnvironment() throws MojoExecutionException {
        return new AdbController.Environment(this.getTargetAdbExecutable()).acceptingBy(DeviceUtils.deviceIsMatching(this.getDeviceSerialNumber())).withDeviceTimeout(this.getDeviceTimeout()).withAdbTimeout(this.getAdbTimeout());
    }

    protected void doWithDevices(@Nonnull Consumer<IDevice, Exception> consumer) throws MojoExecutionException, MojoFailureException {
        try {
            AdbController.adbController().doWithDevices(this.adbEnvironment(), consumer);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

