/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.utils;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.maven.plugins.ProjectEnabledMojoSupport;
import org.echocat.jomon.process.ExecutableDiscovery;
import org.echocat.jomon.process.local.LocalProcessRepository;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemonRepository;
import org.echocat.jomon.process.local.execution.LocalProcessExecuter;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.IdEnabled;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AndroidMojoSupport
extends ProjectEnabledMojoSupport {
    @Nonnull
    protected static final Predicate<IDevice> DEVICE_ONLINE = new Predicate<IDevice>(){

        public boolean apply(@Nullable IDevice input) {
            return input != null && input.isOnline();
        }
    };
    @Nonnull
    protected static final AndroidLogHandler ANDROID_LOG_HANDLER = new AndroidLogHandler();
    @Nullable
    private LocalProcessDaemonRepository _processDaemonRepository;
    @Nullable
    private LocalProcessRepository _processRepository;
    @Parameter(property="adb.executable")
    private String adbExecutable;

    @Nullable
    protected String getAdbExecutable() throws MojoExecutionException {
        return this.adbExecutable;
    }

    @Nonnull
    protected File getTargetAdbExecutable() throws MojoExecutionException {
        String executableFileName = this.getAdbExecutable();
        File executable = ExecutableDiscovery.executableDiscovery().discover(ExecutableDiscovery.Task.executable((String[])new String[]{executableFileName != null ? executableFileName : "adb"}).withinEnvironmentVariables(new String[]{"ANDROID_HOME"}).searchInSubDirectories(new String[]{"platform-tools"}));
        if (executable == null) {
            throw new IllegalArgumentException("Could not find adb executable '" + executableFileName + "' neither as absolute path nor in environment variable ANDROID_HOME nor in system PATH.");
        }
        return executable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected LocalProcessDaemonRepository processDaemonRepository() {
        AndroidMojoSupport androidMojoSupport = this;
        synchronized (androidMojoSupport) {
            if (this._processDaemonRepository == null) {
                this._processDaemonRepository = LocalProcessDaemonRepository.processDaemonRepository();
            }
            return this._processDaemonRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected LocalProcessRepository processRepository() {
        AndroidMojoSupport androidMojoSupport = this;
        synchronized (androidMojoSupport) {
            if (this._processRepository == null) {
                this._processRepository = LocalProcessRepository.processRepository();
            }
            return this._processRepository;
        }
    }

    @Nonnull
    protected LocalProcessExecuter processExecuter() {
        return new LocalProcessExecuter(this.processRepository());
    }

    @Nullable
    protected Long findPidOf(@Nonnull String pidProperty) throws MojoExecutionException {
        Long pid;
        String plainPid = this.getProjectProperty(pidProperty);
        if (!StringUtils.isEmpty((CharSequence)plainPid)) {
            try {
                pid = Long.parseLong(plainPid);
            }
            catch (NumberFormatException ignored) {
                pid = null;
            }
        } else {
            pid = null;
        }
        return pid;
    }

    protected <P extends AutoCloseable & IdEnabled<?>> void registerPid(@Nonnull P process, @Nonnull String pidProperty) throws MojoExecutionException {
        this.validatePidPropertyForRegister(process, pidProperty);
        this.setProjectProperty(pidProperty, ((IdEnabled<?>)process).getId().toString());
    }

    protected <P extends AutoCloseable & IdEnabled<?>> void validatePidPropertyForRegister(@Nonnull P process, @Nonnull String pidProperty) throws MojoExecutionException {
        String pidValue = this.findProjectProperty(pidProperty);
        if (!StringUtils.isEmpty((CharSequence)pidValue)) {
            ResourceUtils.closeQuietly(process);
            throw new MojoExecutionException("The project property '" + pidProperty + "' is already set to '" + pidValue + "' this indicates double usage of this maven plugin without configuring another pid property.");
        }
    }

    protected void unregisterPid(@Nonnull String pidProperty) throws MojoExecutionException {
        this.removeProjectProperty(pidProperty);
    }

    @Nonnull
    protected Duration getDuration(@Nullable String plainDuration, @Nonnull String propertyName) throws MojoExecutionException {
        try {
            return new Duration((String)this.get(plainDuration, propertyName));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    static {
        Log.setLogOutput((Log.ILogOutput)ANDROID_LOG_HANDLER);
    }

    protected static class AndroidLogHandler
    implements Log.ILogOutput {
        @Nonnull
        private static final Map<Log.LogLevel, LogLevel> ANDROID_TO_SLF4J_LEVEL = CollectionUtils.asImmutableMap((Object[])new Object[]{Log.LogLevel.DEBUG, LogLevel.debug, Log.LogLevel.INFO, LogLevel.info, Log.LogLevel.WARN, LogLevel.warning, Log.LogLevel.ERROR, LogLevel.error, Log.LogLevel.ASSERT, LogLevel.error});

        protected AndroidLogHandler() {
        }

        public void printLog(Log.LogLevel logLevel, String tag, String message) {
            Slf4jUtils.log((Logger)LoggerFactory.getLogger((String)tag), (LogLevel)ANDROID_TO_SLF4J_LEVEL.get(logLevel), (String)message);
        }

        public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
            this.printLog(logLevel, tag, message);
        }
    }
}

