/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.utils;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.process.listeners.stream.StreamListeners;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemon;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemonRequirement;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.numbers.IntegerRange;

public abstract class DaemonRequirementSupport<T extends DaemonRequirementSupport<T, D>, D extends LocalProcessDaemon<?>>
implements LocalProcessDaemonRequirement<D> {
    @Nonnull
    protected static final StreamListener<LocalGeneratedProcess> DEFAULT_STREAM_LISTENER = StreamListeners.redirectToLogger();
    @Nonnull
    protected static final IntegerRange EXIT_CODE_VALIDATOR = new IntegerRange(Integer.valueOf(0), Integer.valueOf(2));
    @Nonnull
    private final StreamListenerDelegate _streamListenerDelegate = new StreamListenerDelegate();
    @Nonnull
    private final List<String> _arguments = new ArrayList<String>();
    @Nonnull
    private StreamListener<LocalGeneratedProcess> _streamListener = DEFAULT_STREAM_LISTENER;
    private boolean _logStartOfProcess;
    private boolean _logStartupDoneOfProcess;
    private boolean _logTerminationOfProcess;
    private boolean _shutdownWithThisJvm;

    @Nonnull
    public T withStreamListener(@Nonnull StreamListener<LocalGeneratedProcess> streamListener) {
        this._streamListener = streamListener;
        return this.thisObject();
    }

    @Nonnull
    public T withStreamListener(@Nonnull String streamListenerConfiguration) {
        return this.withStreamListener((StreamListener<LocalGeneratedProcess>)StreamListeners.streamListenerFor(LocalGeneratedProcess.class, (String)streamListenerConfiguration, DEFAULT_STREAM_LISTENER));
    }

    @Nonnull
    public T withArguments(@Nullable Iterable<String> arguments) {
        CollectionUtils.addAll(this._arguments, arguments);
        return this.thisObject();
    }

    @Nonnull
    public T withArguments(String ... arguments) {
        CollectionUtils.addAll(this._arguments, (Object[])arguments);
        return this.thisObject();
    }

    @Nonnull
    public T withArgument(@Nonnull String argument) {
        return this.withArguments(argument);
    }

    @Nonnull
    public List<String> getArguments() {
        return Collections.unmodifiableList(this._arguments);
    }

    @Nonnull
    public T whichLogsStartOfProcess(boolean log) {
        this._logStartOfProcess = log;
        return this.thisObject();
    }

    @Nonnull
    public T whichLogsStartOfProcess() {
        return this.whichLogsStartOfProcess(true);
    }

    @Nonnull
    public T whichNotLogStartOfProcess() {
        return this.whichLogsStartOfProcess(false);
    }

    @Nonnull
    public T whichLogsStartupDoneOfProcess(boolean log) {
        this._logStartupDoneOfProcess = log;
        return this.thisObject();
    }

    @Nonnull
    public T whichLogsStartupDoneOfProcess() {
        return this.whichLogsStartupDoneOfProcess(true);
    }

    @Nonnull
    public T whichNotLogStartupDoneOfProcess() {
        return this.whichLogsStartupDoneOfProcess(false);
    }

    @Nonnull
    public T whichLogsTerminationOfProcess(boolean log) {
        this._logTerminationOfProcess = log;
        return this.thisObject();
    }

    @Nonnull
    public T whichLogsTerminationOfProcess() {
        return this.whichLogsTerminationOfProcess(true);
    }

    @Nonnull
    public T whichNotLogTerminationOfProcess() {
        return this.whichLogsTerminationOfProcess(false);
    }

    @Nonnull
    public T whichShuttingDownWithThisJvm(boolean shutdownWithThisJvm) {
        this._shutdownWithThisJvm = shutdownWithThisJvm;
        return this.thisObject();
    }

    @Nonnull
    public T whichShuttingDownWithThisJvm() {
        return this.whichShuttingDownWithThisJvm(true);
    }

    @Nonnull
    public T whichNotShuttingDownWithThisJvm() {
        return this.whichShuttingDownWithThisJvm(false);
    }

    public boolean isShutdownWithThisJvm() {
        return this._shutdownWithThisJvm;
    }

    protected abstract void logStartOfProcess(@Nonnull LocalGeneratedProcess var1);

    protected abstract void logStartupDoneOfProcess(@Nonnull LocalGeneratedProcess var1);

    protected abstract void logTerminationOfProcess(@Nonnull LocalGeneratedProcess var1, boolean var2);

    @Nonnull
    public StreamListener<LocalGeneratedProcess> getStreamListener() {
        return this._streamListenerDelegate;
    }

    @Nonnull
    public Predicate<Integer> getExitCodeValidator() {
        return EXIT_CODE_VALIDATOR;
    }

    @Nonnull
    protected T thisObject() {
        return (T)this;
    }

    public class StreamListenerDelegate
    implements StreamListener<LocalGeneratedProcess> {
        public boolean canHandleReferenceType(@Nonnull Class<?> type) {
            return DaemonRequirementSupport.this._streamListener.canHandleReferenceType(type);
        }

        public void notifyProcessStarted(@Nonnull LocalGeneratedProcess process) {
            if (DaemonRequirementSupport.this._logStartOfProcess) {
                DaemonRequirementSupport.this.logStartOfProcess(process);
            }
            DaemonRequirementSupport.this._streamListener.notifyProcessStarted((GeneratedProcess)process);
        }

        public void notifyProcessStartupDone(@Nonnull LocalGeneratedProcess process) {
            if (DaemonRequirementSupport.this._logStartupDoneOfProcess) {
                DaemonRequirementSupport.this.logStartupDoneOfProcess(process);
            }
            DaemonRequirementSupport.this._streamListener.notifyProcessStartupDone((GeneratedProcess)process);
        }

        public void notifyOutput(@Nonnull LocalGeneratedProcess process, @Nonnull byte[] data, @Nonnegative int offset, @Nonnegative int length, @Nonnull StreamType streamType) {
            DaemonRequirementSupport.this._streamListener.notifyOutput((GeneratedProcess)process, data, offset, length, streamType);
        }

        public void flushOutput(@Nonnull LocalGeneratedProcess process, @Nonnull StreamType streamType) {
            DaemonRequirementSupport.this._streamListener.flushOutput((GeneratedProcess)process, streamType);
        }

        public void notifyProcessTerminated(@Nonnull LocalGeneratedProcess process, boolean success) {
            if (DaemonRequirementSupport.this._logTerminationOfProcess) {
                DaemonRequirementSupport.this.logTerminationOfProcess(process, success);
            }
            DaemonRequirementSupport.this._streamListener.notifyProcessTerminated((GeneratedProcess)process, success);
        }
    }
}

