/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.xml.DocumentContainer;

public class ManifestUtils {
    @Nonnull
    public static String getPackageNameFromAndroidManifest(@Nonnull File androidManifestFile) {
        URL xmlURL;
        try {
            xmlURL = androidManifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error while trying to figure out package name from inside AndroidManifest.xml file " + androidManifestFile, e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        Object packageName = JXPathContext.newContext((Object)documentContainer).getValue("manifest/@package", String.class);
        return (String)packageName;
    }

    @Nonnull
    public static String findInstrumentationRunnerInAndroidManifest(@Nonnull File androidManifestFile) {
        Object instrumentationRunner;
        URL xmlURL;
        try {
            xmlURL = androidManifestFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error while trying to figure out instrumentation runner from inside AndroidManifest.xml file " + androidManifestFile, e);
        }
        DocumentContainer documentContainer = new DocumentContainer(xmlURL);
        try {
            instrumentationRunner = JXPathContext.newContext((Object)documentContainer).getValue("manifest//instrumentation/@android:name", String.class);
        }
        catch (JXPathNotFoundException ignored) {
            instrumentationRunner = null;
        }
        return (String)instrumentationRunner;
    }

    private ManifestUtils() {
    }
}

