/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins;

import com.android.ddmlib.IDevice;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.platform.DeviceController.Environment;
import org.echocat.rundroid.maven.plugins.utils.ManifestAndAdbMojoSupport;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.File;
import java.io.IOException;

import static org.apache.maven.plugins.annotations.LifecyclePhase.PRE_INTEGRATION_TEST;
import static org.echocat.rundroid.maven.plugins.platform.DeviceController.Environment.deviceEnvironment;
import static org.echocat.rundroid.maven.plugins.platform.DeviceController.deviceController;

@SuppressWarnings("InstanceVariableNamingConvention")
@Mojo(
    name = "installApk",
    defaultPhase = PRE_INTEGRATION_TEST
)
public class InstallApkMojo extends ManifestAndAdbMojoSupport {

    @Parameter(property = "apk", defaultValue = "${project.build.directory}/${project.build.finalName}.apk", required = true)
    private File apk;
    @Parameter(property = "adb.installTimeout", defaultValue = "5m")
    private String installTimeout;

    @Override
    public void call() throws Exception {
        //noinspection LocalVariableHidesMemberVariable
        final File apk = getApk();
        doWithDevices(new Consumer<IDevice, Exception>() { @Override public void consume(@Nullable IDevice device) throws Exception {
            final Environment environment = deviceEnvironment(device)
                .withCommandTimeout(getInstallTimeout());
            deviceController().installLocalFile(environment, apk, getInstrumentationPackage(), true);
        }});
    }

    @Nonnull
    protected Duration getInstallTimeout() throws MojoExecutionException {
        return getDuration(installTimeout, "installTimeout");
    }

    @Nonnull
    protected File getApk() throws MojoExecutionException {
        final File result = apk;
        if (result == null) {
            throw new MojoExecutionException("There is no apk specified.");
        }
        if (!result.exists()) {
            throw new MojoExecutionException("The apk '" + result + "' does not exist.");
        }
        if (!result.isFile()) {
            throw new MojoExecutionException("The apk '" + result + "' is not a file.");
        }
        try {
            return result.getCanonicalFile();
        } catch (final IOException e) {
            throw new MojoExecutionException("It was not possible to make apk '" + result + "' canonical.", e);
        }
    }

}
