/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.logcat;

import org.echocat.jomon.process.listeners.startup.StartupListener;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.rundroid.maven.plugins.utils.DaemonRequirementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import java.io.File;

import static org.echocat.jomon.process.ProcessUtils.toEscapedCommandLine;
import static org.echocat.jomon.process.listeners.startup.StartupListener.NoopStartupListener.noop;

public class LogcatDaemonRequirement extends DaemonRequirementSupport<LogcatDaemonRequirement, LogcatDaemon> {

    private static final Logger LOG = LoggerFactory.getLogger(LogcatDaemonRequirement.class);

    @Nonnull
    public static LogcatDaemonRequirement logcatDaemon(@Nonnull File adbExecutable) {
        return new LogcatDaemonRequirement(adbExecutable);
    }

    @Nonnull
    private final File _adbExecutable;

    public LogcatDaemonRequirement(@Nonnull File executable) {
        _adbExecutable = executable;
    }

    @Nonnull
    @Override
    public Class<LogcatDaemon> getType() {
        return LogcatDaemon.class;
    }

    @Nonnull
    public File getAdbExecutable() {
        return _adbExecutable;
    }

    @Override
    protected void logStartOfProcess(@Nonnull LocalGeneratedProcess process) {
        LOG.info("Starting logcat: " + toEscapedCommandLine(process.getArguments()) + "...");
    }

    @Override
    protected void logStartupDoneOfProcess(@Nonnull LocalGeneratedProcess process) {
        LOG.info("Logcat #" + process.getId() + " started successful.");
    }

    @Override
    protected void logTerminationOfProcess(@Nonnull LocalGeneratedProcess process, boolean success) {
        if (success) {
            LOG.info("Logcat #" + process.getId() + " exited successful. ExitCode: " + process.exitValue());
        } else {
            LOG.warn("Logcat #" + process.getId() + " exited with error. ExitCode: " + process.exitValue());
        }
    }

    @Nonnull
    @Override
    public StartupListener<LocalGeneratedProcess> getStartupListener() {
        return noop();
    }

}
