/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.utils;

import com.android.ddmlib.IDevice;
import com.google.common.base.Predicate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static org.apache.commons.lang3.StringUtils.deleteWhitespace;
import static org.apache.commons.lang3.StringUtils.isEmpty;

public class DeviceUtils {

    @Nonnull
    public static String toString(@Nonnull IDevice device) {
        final StringBuilder sb = new StringBuilder();
        sb.append(device.getSerialNumber());
        if (device.getAvdName() != null) {
            sb.append(':').append(device.getAvdName());
        }
        final String manufacturer = deleteWhitespace(device.getProperty("ro.product.manufacturer"));
        if (!isEmpty(manufacturer)) {
            sb.append(':').append(manufacturer);
        }
        final String model = deleteWhitespace(device.getProperty("ro.product.model"));
        if (!isEmpty(model)) {
            sb.append(':').append(model);
        }
        return sb.toString();
    }

    @Nonnull
    public static String toNormalizedString(@Nonnull IDevice device) {
        return IdentifierUtils.normalize(toString(device));
    }

    private DeviceUtils() {}

    @Nonnull
    public static Predicate<IDevice> deviceIsMatching(@Nonnull final String serialNumber) {
        return new Predicate<IDevice>() { @Override public boolean apply(@Nullable IDevice input) {
            return input != null && input.isOnline() && serialNumber.equals(input.getSerialNumber());
        }};
    }
}
