/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.utils;

import javax.annotation.Nonnull;

import static java.lang.Character.isAlphabetic;
import static java.lang.Character.isDigit;

public class IdentifierUtils {

    @Nonnull
    public static String normalize(@Nonnull String string) {
        final StringBuilder sb = new StringBuilder();
        char lastCharacter = 0;
        for (final char c : string.toCharArray()) {
            if (isNormalizedCharacter(c)) {
                sb.append(c);
            } else if (isNormalizedCharacter(lastCharacter)) {
                sb.append('_');
            }
            lastCharacter = c;
        }
        return sb.toString();
    }

    public static boolean isNormalizedCharacter(char c) {
        return isAlphabetic(c)
            || isDigit(c)
            || c == '_'
            || c == '.'
            || c == '-'
            ;
    }

    private IdentifierUtils() {}

}
