/*****************************************************************************************
 * *** BEGIN LICENSE BLOCK *****
 *
 * Version: MPL 2.0
 *
 * echocat Maven Rundroid Plugin, Copyright (c) 2012-2013 echocat
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * *** END LICENSE BLOCK *****
 ****************************************************************************************/

package org.echocat.rundroid.maven.plugins.utils;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.File;

import static org.apache.commons.lang3.StringUtils.isEmpty;
import static org.echocat.rundroid.maven.plugins.utils.ManifestUtils.getPackageNameFromAndroidManifest;

@SuppressWarnings("InstanceVariableNamingConvention")
public abstract class ManifestAndAdbMojoSupport extends AdbMojoSupport {

    @Parameter(property = "android.manifestFile", defaultValue = "${project.basedir}/AndroidManifest.xml")
    private File manifestFile;
    @Parameter(property = "android.instrumentation.package")
    private String instrumentationPackage;

    @Nonnull
    protected String getInstrumentationPackage() throws MojoExecutionException {
        String result = instrumentationPackage;
        if (isEmpty(result)) {
            final File file = findManifestFile();
            if (file == null) {
                throw new MojoExecutionException("Neither an instrumentationPackage was specified nor a manifestFile.");
            }
            result = getPackageNameFromAndroidManifest(file);
        }
        return result;
    }

    @Nullable
    protected File findManifestFile() throws MojoExecutionException {
        final File file = manifestFile;
        if (file != null) {
            if (!file.exists()) {
                throw new MojoExecutionException("manifestFile " + file + " does not exist.");
            }
            if (!file.isFile()) {
                throw new MojoExecutionException("manifestFile " + file + " is  not a file.");
            }
        }
        return file;
    }

}
