/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins;

import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemon;
import org.echocat.rundroid.maven.plugins.logcat.Logcat;
import org.echocat.rundroid.maven.plugins.logcat.LogcatDaemonRequirement;
import org.echocat.rundroid.maven.plugins.logcat.LogcatMojoSupport;
import org.echocat.rundroid.maven.plugins.utils.DeviceUtils;

@Mojo(name="startLogcat", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartLogcatMojo
extends LogcatMojoSupport {
    @Parameter(property="logcat.arguments")
    private String[] logcatArguments;
    @Parameter(property="logcat.output", defaultValue="redirectToLogger", required=true)
    private String logcatOutput;
    @Parameter(property="logcat.logStart", defaultValue="true")
    private boolean logLogcatStart;
    @Parameter(property="logcat.logStartupDone", defaultValue="true")
    private boolean logLogcatStartupDone;
    @Parameter(property="logcat.logTermination", defaultValue="true")
    private boolean logLogcatTermination;
    @Parameter(property="logcat.shutdownWithMaven", defaultValue="true")
    private boolean shutdownLogcatWithMaven;

    public void call() throws Exception {
        if (this.shutdownLogcatWithMaven) {
            Logcat logcat = new Logcat(DeviceUtils.deviceIsMatching(this.getDeviceSerialNumber()), this.getTargetAdbExecutable()).withArguments(this.getLogcatArguments()).withStreamListener(this.getLogcatOutput()).whichLogsStart(this.logLogcatStart).whichLogsStartupDone(this.logLogcatStartupDone).whichLogsTermination(this.logLogcatTermination);
            logcat.start();
            this.registerLogcat(logcat);
            this.registerPidOf(logcat);
        } else {
            LocalProcessDaemon daemon = (LocalProcessDaemon)this.processDaemonRepository().generate(((LogcatDaemonRequirement)((LogcatDaemonRequirement)((LogcatDaemonRequirement)((LogcatDaemonRequirement)((LogcatDaemonRequirement)LogcatDaemonRequirement.logcatDaemon(this.getTargetAdbExecutable()).withArguments(this.getLogcatArguments())).withStreamListener(this.getLogcatOutput())).whichLogsStartOfProcess(this.logLogcatStart)).whichLogsStartupDoneOfProcess(this.logLogcatStartupDone)).whichLogsTerminationOfProcess(this.logLogcatTermination)).whichShuttingDownWithThisJvm(this.shutdownLogcatWithMaven));
            this.registerPidOf(daemon);
        }
    }

    protected void registerPidOf(@Nonnull LocalProcessDaemon<?> daemon) throws MojoExecutionException {
        this.registerPid(daemon.getProcess(), this.getLogcatPidProperty());
    }

    protected void registerPidOf(@Nonnull Logcat logcat) throws MojoExecutionException {
        this.registerPid(logcat, this.getLogcatPidProperty());
    }

    @Nonnull
    protected String[] getLogcatArguments() throws MojoExecutionException {
        return this.logcatArguments;
    }

    @Nonnull
    protected String getLogcatOutput() throws MojoExecutionException {
        String result = this.logcatOutput;
        if (result == null) {
            throw new MojoExecutionException("No output provided.");
        }
        return result;
    }
}

