/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.rundroid.maven.plugins.logcat.Logcat;
import org.echocat.rundroid.maven.plugins.logcat.LogcatDaemonQuery;
import org.echocat.rundroid.maven.plugins.logcat.LogcatMojoSupport;

@Mojo(name="stopLogcat", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class StopLogcatMojo
extends LogcatMojoSupport {
    @Parameter(property="logcat.startsWithArguments")
    private String[] logcatStartsWithArguments;

    public void call() throws Exception {
        Long pid = this.findPidOf(this.getLogcatPidProperty());
        if (pid != null) {
            Logcat logcat = this.findLogcat(pid);
            if (logcat != null) {
                ResourceUtils.closeQuietly((AutoCloseable)logcat);
                this.unregisterLogcat(logcat);
            } else {
                this.processDaemonRepository().removeBy((Object)pid);
            }
        } else {
            List<String> args = Arrays.asList("logcat");
            CollectionUtils.addAll(args, (Object[])this.getLogcatStartsWithArguments());
            this.processDaemonRepository().removeBy(((LogcatDaemonQuery)LogcatDaemonQuery.logcatDaemon().withExecutable(this.getTargetAdbExecutable())).whichStartsWithArguments(args));
        }
        this.unregisterPid();
    }

    protected void unregisterPid() throws MojoExecutionException {
        this.unregisterPid(this.getLogcatPidProperty());
    }

    @Nonnull
    protected String[] getLogcatStartsWithArguments() throws MojoExecutionException {
        return this.logcatStartsWithArguments;
    }
}

