/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.platform.XmlTestRunListener;
import org.echocat.rundroid.maven.plugins.utils.ManifestAndAdbMojoSupport;
import org.echocat.rundroid.maven.plugins.utils.ManifestUtils;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class TestMojo
extends ManifestAndAdbMojoSupport {
    @Nonnull
    protected static final String INDENT = "  ";
    @Parameter(readonly=true, defaultValue="false", property="maven.test.skip")
    private boolean mavenTestSkip;
    @Parameter(property="skipTests")
    private Boolean skipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    private boolean ignoreTestFailure;
    @Parameter(property="maven.test.error.ignore", defaultValue="false")
    private boolean ignoreTestError;
    @Parameter(property="android.test.timeout", defaultValue="10m")
    private String testTimeout;
    @Parameter(property="android.instrumentation.runner")
    private String instrumentationRunner;
    @Parameter(property="android.test.packages")
    private List<String> testPackages;
    @Parameter(property="android.test.classes")
    private List<String> testClasses;
    @Parameter(property="android.test.coverage", defaultValue="false")
    private boolean testCoverage;
    @Parameter(property="android.test.debug", defaultValue="false")
    private boolean testDebug;
    @Parameter(property="android.test.logOnly", defaultValue="false")
    private boolean testLogOnly;
    @Parameter(property="android.test.size")
    private IRemoteAndroidTestRunner.TestSize testSize;
    @Parameter(property="android.test.reports.directory", defaultValue="${project.build.directory}/surefire-reports")
    private File reportsDirectory;

    public void call() throws Exception {
        if (this.isEnableIntegrationTest()) {
            this.doWithDevices(new Consumer<IDevice, Exception>(){

                public void consume(@Nullable IDevice device) throws Exception {
                    for (String testPackage : TestMojo.this.getTestPackages()) {
                        String[] classes;
                        RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(TestMojo.this.getInstrumentationPackage(), TestMojo.this.getInstrumentationRunner(), (IShellEnabledDevice)device);
                        if (!testPackage.isEmpty()) {
                            runner.setTestPackageName(testPackage);
                        }
                        if ((classes = TestMojo.this.getTestClassesAsArray()).length > 0) {
                            runner.setClassNames(classes);
                        }
                        runner.setCoverage(TestMojo.this.testCoverage);
                        runner.setDebug(TestMojo.this.testDebug);
                        runner.setLogOnly(TestMojo.this.testLogOnly);
                        if (TestMojo.this.testSize != null) {
                            runner.setTestSize(TestMojo.this.testSize);
                        }
                        runner.setMaxtimeToOutputResponse((int)TestMojo.this.getTestTimeout().in(TimeUnit.MILLISECONDS));
                        TestRunListener listener = TestMojo.this.createTestRunListener();
                        runner.run(new ITestRunListener[]{TestMojo.this.createJunitReportListener(device), listener});
                        if (listener.getErrorMessage() == null) continue;
                        throw new MojoFailureException(listener.getErrorMessage());
                    }
                }
            });
        } else {
            this.getLog().info((CharSequence)"Skipping tests");
        }
    }

    @Nonnull
    protected XmlTestRunListener createJunitReportListener(@Nonnull IDevice device) throws MojoExecutionException, IOException {
        File reportDir = this.getReportsDirectory();
        FileUtils.forceMkdir((File)reportDir);
        return new XmlTestRunListener(device, reportDir);
    }

    @Nonnull
    protected TestRunListener createTestRunListener() throws MojoExecutionException {
        return new TestRunListener();
    }

    protected boolean isEnableIntegrationTest() throws MojoFailureException, MojoExecutionException {
        boolean skip = this.skipTests != null ? this.skipTests : this.mavenTestSkip;
        return !skip;
    }

    @Nonnull
    protected File getReportsDirectory() throws MojoExecutionException {
        return (File)this.get(this.reportsDirectory, "reportsDirectory");
    }

    @Nonnull
    protected List<String> getTestPackages() throws MojoExecutionException {
        List result = this.splitUp(this.testPackages);
        return result.isEmpty() ? CollectionUtils.asList((Object[])new String[]{""}) : result;
    }

    @Nonnull
    protected List<String> getTestClasses() throws MojoExecutionException {
        return this.splitUp(this.testClasses);
    }

    @Nonnull
    protected String[] getTestClassesAsArray() throws MojoExecutionException {
        List<String> classes = this.getTestClasses();
        return classes.toArray(new String[classes.size()]);
    }

    @Nonnull
    protected Duration getTestTimeout() throws MojoExecutionException {
        return this.getDuration(this.testTimeout, "testTimeout");
    }

    @Nullable
    protected String getInstrumentationRunner() throws MojoExecutionException {
        File file;
        String result = this.instrumentationRunner;
        if (StringUtils.isEmpty((CharSequence)result) && (file = this.findManifestFile()) != null) {
            result = ManifestUtils.findInstrumentationRunnerInAndroidManifest(file);
        }
        return result;
    }

    @Nonnull
    protected List<String> splitUp(@Nullable List<String> inputs) throws MojoExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        if (inputs != null) {
            for (String plainInput : inputs) {
                for (String subPlainInput : StringUtils.split((String)plainInput, (char)',')) {
                    String trimmedInput = subPlainInput.trim();
                    if (trimmedInput.isEmpty()) continue;
                    result.add(trimmedInput);
                }
            }
        }
        return result;
    }

    protected class TestRunListener
    implements ITestRunListener {
        @Nonnegative
        private int _testCount;
        @Nonnegative
        private int _testRunCount;
        @Nonnegative
        private int _testErrorCount;
        @Nonnegative
        private int _testFailureCount;
        @Nullable
        private String _errorMessage;

        protected TestRunListener() {
        }

        public void testRunStarted(String runName, int testCount) {
            this._testCount = testCount;
            TestMojo.this.getLog().info((CharSequence)("  Run started: " + runName + ", " + testCount + " tests:"));
        }

        public void testStarted(TestIdentifier identifier) {
            ++this._testRunCount;
            TestMojo.this.getLog().info((CharSequence)String.format("%1$s%1$sStart [%2$d/%3$d]: %4$s", TestMojo.INDENT, this._testRunCount, this._testCount, identifier.toString()));
        }

        public void testFailed(ITestRunListener.TestFailure status, TestIdentifier identifier, String trace) {
            if (status == ITestRunListener.TestFailure.ERROR) {
                ++this._testErrorCount;
            } else {
                ++this._testFailureCount;
            }
            TestMojo.this.getLog().error((CharSequence)("    " + status.name() + ":" + identifier));
            TestMojo.this.getLog().error((CharSequence)("    " + trace));
        }

        public void testEnded(TestIdentifier identifier, Map<String, String> testMetrics) {
            TestMojo.this.getLog().info((CharSequence)String.format("%1$s%1$sEnd [%2$d/%3$d]: %4$s", TestMojo.INDENT, this._testRunCount, this._testCount, identifier.toString()));
            this.logMetrics(testMetrics);
        }

        public void testRunFailed(String errorMessage) {
            this._errorMessage = errorMessage;
            TestMojo.this.getLog().info((CharSequence)("  Run failed: " + errorMessage));
        }

        public void testRunStopped(long elapsedTime) {
            TestMojo.this.getLog().info((CharSequence)("  Run stopped:" + new Duration(elapsedTime)));
        }

        public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
            TestMojo.this.getLog().info((CharSequence)("  Run ended: " + new Duration(elapsedTime)));
            String message = "  Tests run: " + this._testRunCount + (this._testRunCount < this._testCount ? " (of " + this._testCount + ")" : "") + ",  Failures: " + this._testFailureCount + ",  Errors: " + this._testErrorCount;
            if (this.hasFailuresOrErrors()) {
                TestMojo.this.getLog().error((CharSequence)message);
            } else {
                TestMojo.this.getLog().info((CharSequence)message);
            }
        }

        protected void logMetrics(@Nonnull Map<String, String> metrics) {
            for (Map.Entry<String, String> entry : metrics.entrySet()) {
                TestMojo.this.getLog().info((CharSequence)("    " + entry.getKey() + ": " + entry.getValue()));
            }
        }

        protected boolean hasFailuresOrErrors() {
            boolean result = TestMojo.this.ignoreTestFailure && TestMojo.this.ignoreTestError ? false : (TestMojo.this.ignoreTestFailure ? this._testErrorCount > 0 : (TestMojo.this.ignoreTestError ? this._testFailureCount > 0 : this._testErrorCount > 0 || this._testFailureCount > 0));
            return result;
        }

        @Nullable
        protected String getErrorMessage() {
            return this._errorMessage;
        }
    }
}

