/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.emulator;

import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.echocat.jomon.process.CouldNotStartException;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.jomon.process.local.LocalGeneratedProcessRequirement;
import org.echocat.jomon.process.local.LocalProcessRepository;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemon;
import org.echocat.jomon.process.local.daemon.LocalProcessDaemonRequirement;
import org.echocat.jomon.runtime.generation.Generator;
import org.echocat.jomon.runtime.generation.Requirement;
import org.echocat.rundroid.maven.plugins.emulator.EmulatorDaemonRequirement;

@ThreadSafe
public class EmulatorDaemon
extends LocalProcessDaemon<EmulatorDaemonRequirement> {
    @Nonnull
    private static final Map<LocalGeneratedProcess, String> PROCESS_TO_SERIAL_NUMBER = new WeakHashMap<LocalGeneratedProcess, String>();
    @Nonnull
    private final EmulatorDaemonRequirement _requirement;
    @Nullable
    private Integer _port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String findSerialNumberFor(@Nonnull LocalGeneratedProcess process) {
        Map<LocalGeneratedProcess, String> map = PROCESS_TO_SERIAL_NUMBER;
        synchronized (map) {
            return PROCESS_TO_SERIAL_NUMBER.get(process);
        }
    }

    public EmulatorDaemon(@Nonnull LocalProcessRepository processRepository, @Nonnull EmulatorDaemonRequirement requirement) throws CouldNotStartException {
        super(processRepository, (LocalProcessDaemonRequirement)requirement);
        this._requirement = requirement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected LocalGeneratedProcess generateProcess(@Nonnull Generator<LocalGeneratedProcess, LocalGeneratedProcessRequirement> repository, @Nonnull EmulatorDaemonRequirement requirement) throws Exception {
        List<String> arguments = requirement.getArguments();
        if (arguments.contains("-port")) {
            throw new MojoFailureException("Fix setting of a port for the emulator is currently not supported! It is required that the detector is able to find the free port automatically.");
        }
        int port = this.findFreePort();
        LocalGeneratedProcess process = (LocalGeneratedProcess)repository.generate((Requirement)((LocalGeneratedProcessRequirement)((LocalGeneratedProcessRequirement)LocalGeneratedProcessRequirement.process((File)requirement.getExecutable()).whichIsDaemon(requirement.isShutdownWithThisJvm())).withArguments(new String[]{"-avd", requirement.getAvd(), "-port", Integer.toString(port)})).withArguments(arguments));
        this._port = port;
        Map<LocalGeneratedProcess, String> map = PROCESS_TO_SERIAL_NUMBER;
        synchronized (map) {
            PROCESS_TO_SERIAL_NUMBER.put(process, "emulator-" + port);
        }
        return process;
    }

    @Nonnegative
    private int findFreePort() throws Exception {
        InetAddress address = InetAddress.getLocalHost();
        Integer result = null;
        for (int port = 5554; result == null && port <= 5584; port += 2) {
            if (!this.isPortFree(address, port) || !this.isPortFree(address, port + 1)) continue;
            result = port;
        }
        if (result == null) {
            throw new MojoFailureException("Could not find any free port between 5554 and 5584 to bind the emulator on.");
        }
        return result;
    }

    protected boolean isPortFree(@Nonnull InetAddress address, @Nonnegative int port) throws Exception {
        boolean result;
        try {
            ServerSocket socket = new ServerSocket();
            socket.bind(new InetSocketAddress(address, port));
            socket.close();
            result = true;
        }
        catch (BindException ignored) {
            result = false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not find test the port " + port + " on '" + address + "'.", (Exception)e);
        }
        return result;
    }

    @Nullable
    public int getPort() {
        Integer port = this._port;
        if (port == null) {
            throw new IllegalStateException("The emulator is currently not running.");
        }
        return port;
    }

    @Nonnull
    public String getSerialNumber() {
        return "emulator-" + this.getPort();
    }

    public void close() {
        try {
            this._port = null;
        }
        finally {
            super.close();
        }
    }

    @Nonnull
    public String getAvd() {
        return this._requirement.getAvd();
    }

    @Nonnull
    public List<String> getArguments() {
        return this._requirement.getArguments();
    }

    public String toString() {
        return "Emulator{port=" + this._port + ", avd=" + this.getAvd() + "}";
    }
}

