/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.emulator;

import java.io.File;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.ProcessUtils;
import org.echocat.jomon.process.listeners.startup.StartupListener;
import org.echocat.jomon.process.local.LocalGeneratedProcess;
import org.echocat.rundroid.maven.plugins.emulator.EmulatorDaemon;
import org.echocat.rundroid.maven.plugins.utils.DaemonRequirementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmulatorDaemonRequirement
extends DaemonRequirementSupport<EmulatorDaemonRequirement, EmulatorDaemon> {
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorDaemonRequirement.class);
    @Nonnull
    private final File _executable;
    @Nonnull
    private final String _avd;
    @Nonnull
    private File _adbExecutable;

    @Nonnull
    public static EmulatorDaemonRequirement emulatorDaemon(@Nonnull File executable, @Nonnull String avd) {
        return new EmulatorDaemonRequirement(executable, avd);
    }

    public EmulatorDaemonRequirement(@Nonnull File executable, @Nonnull String avd) {
        this._executable = executable;
        this._avd = avd;
    }

    @Nonnull
    public EmulatorDaemonRequirement withAdbExecutable(@Nonnull File adbExecutable) {
        this._adbExecutable = adbExecutable;
        return this;
    }

    @Nonnull
    public Class<EmulatorDaemon> getType() {
        return EmulatorDaemon.class;
    }

    @Nonnull
    public File getExecutable() {
        return this._executable;
    }

    @Nonnull
    public String getAvd() {
        return this._avd;
    }

    @Nonnull
    public File getAdbExecutable() {
        return this._adbExecutable;
    }

    @Override
    protected void logStartOfProcess(@Nonnull LocalGeneratedProcess process) {
        LOG.info("Starting emulator: " + ProcessUtils.toEscapedCommandLine((Iterable)process.getArguments()) + "...");
    }

    @Override
    protected void logStartupDoneOfProcess(@Nonnull LocalGeneratedProcess process) {
        LOG.info("Emulator #" + process.getId() + " (" + EmulatorDaemon.findSerialNumberFor(process) + ") started successful.");
    }

    @Override
    protected void logTerminationOfProcess(@Nonnull LocalGeneratedProcess process, boolean success) {
        if (success) {
            LOG.info("Emulator #" + process.getId() + " (" + EmulatorDaemon.findSerialNumberFor(process) + ") exited successful. ExitCode: " + process.exitValue());
        } else {
            LOG.warn("Emulator #" + process.getId() + " (" + EmulatorDaemon.findSerialNumberFor(process) + ") exited with error. ExitCode: " + process.exitValue());
        }
    }

    @Nonnull
    public StartupListener<LocalGeneratedProcess> getStartupListener() {
        return new StartupListener.NoopStartupListener();
    }
}

