/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.emulator;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.process.ExecutableDiscovery;
import org.echocat.rundroid.maven.plugins.utils.AndroidMojoSupport;

public abstract class EmulatorMojoSupport
extends AndroidMojoSupport {
    @Parameter(property="emulator.executable")
    private String emulatorExecutable;
    @Parameter(property="emulator.architecture", defaultValue="x86", required=true)
    private String emulatorArchitecture;
    @Parameter(property="emulator.avd", defaultValue="default", required=true)
    private String avd;
    @Parameter(property="emulator.pidProperty", defaultValue="emulator.pid", required=true)
    private String emulatorPidProperty;
    @Parameter(property="emulator.emulatorSerialNumberProperty", defaultValue="android.device.serialNumber", required=true)
    private String emulatorSerialNumberProperty;

    @Nullable
    protected String getEmulatorExecutable() throws MojoExecutionException {
        return this.emulatorExecutable;
    }

    @Nonnull
    protected File getTargetEmulatorExecutable() throws MojoExecutionException {
        String executableFileName = this.getTargetEmulatorExecutableFileName();
        File executable = ExecutableDiscovery.executableDiscovery().discover(ExecutableDiscovery.Task.executable((String[])new String[]{executableFileName}).withinEnvironmentVariables(new String[]{"ANDROID_HOME"}).searchInSubDirectories(new String[]{"tools"}));
        if (executable == null) {
            throw new IllegalArgumentException("Could not find emulator executable '" + executableFileName + "' neither as absolute path nor in environment variable ANDROID_HOME nor in system PATH.");
        }
        return executable;
    }

    @Nonnull
    protected String getTargetEmulatorExecutableFileName() throws MojoExecutionException {
        String executableFileNameFromRequirement = this.getEmulatorExecutable();
        String executableFileName = StringUtils.isEmpty((CharSequence)executableFileNameFromRequirement) ? "emulator-" + this.getEmulatorArchitecture() : executableFileNameFromRequirement;
        return executableFileName;
    }

    @Nonnull
    protected String getEmulatorArchitecture() throws MojoExecutionException {
        String result = this.emulatorArchitecture;
        if (result == null) {
            throw new MojoExecutionException("No architecture set.");
        }
        return result;
    }

    @Nonnull
    protected String getAvd() throws MojoExecutionException {
        String result = this.avd;
        if (result == null) {
            throw new MojoExecutionException("No avd set.");
        }
        return result;
    }

    @Nonnull
    protected String getEmulatorPidProperty() throws MojoExecutionException {
        String result = this.emulatorPidProperty;
        if (result == null) {
            throw new MojoExecutionException("No emulatorPidProperty set.");
        }
        return result;
    }

    @Nonnull
    public String getEmulatorSerialNumberProperty() throws MojoExecutionException {
        String result = this.emulatorSerialNumberProperty;
        if (result == null) {
            throw new MojoExecutionException("No emulatorSerialNumberProperty set.");
        }
        return result;
    }
}

