/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.logcat;

import com.android.ddmlib.IDevice;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.ProcessUtils;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.process.listeners.stream.StreamListeners;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.IdEnabled;
import org.echocat.rundroid.maven.plugins.platform.AdbController;
import org.echocat.rundroid.maven.plugins.platform.AdbProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logcat
implements AutoCloseable,
IdEnabled<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(Logcat.class);
    @Nonnull
    private static final AtomicLong IDS = new AtomicLong(1L);
    @Nonnegative
    private final long _id = IDS.getAndIncrement();
    @Nonnull
    private final Predicate<IDevice> _devicePredicate;
    @Nonnull
    private final File _adbExecutable;
    @Nonnull
    private StreamListener<AdbProcess> _streamListener = Logcat.defaultStreamListener();
    @Nullable
    private List<String> _arguments;
    @Nonnull
    private Duration _deviceTimeout = new Duration("2m");
    @Nonnull
    private Duration _adbTimeout = new Duration("30s");
    private volatile boolean _logStart;
    private volatile boolean _logStartupDone;
    private volatile boolean _logTermination;
    @Nullable
    private AdbProcess _process;

    public Logcat(@Nonnull Predicate<IDevice> devicePredicate, @Nonnull File adbExecutable) {
        this._devicePredicate = devicePredicate;
        this._adbExecutable = adbExecutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Logcat logcat = this;
        synchronized (logcat) {
            if (this._process == null) {
                if (this.isLogStart()) {
                    LOG.info("Starting " + ProcessUtils.toEscapedCommandLine((Object)"logcat", this.getArguments()) + "...");
                }
                AdbController.adbController().doWithDevices(AdbController.Environment.adbEnvironment(this.getAdbExecutable()).withDeviceTimeout(this.getDeviceTimeout()).withAdbTimeout(this.getAdbTimeout()).acceptingBy(this.getDevicePredicate()), this.deviceConsumer());
                if (this.isLogStartupDone()) {
                    LOG.info("Logcat #" + this.getId() + " started successful.");
                }
            }
        }
    }

    @Nonnull
    protected Consumer<IDevice, Exception> deviceConsumer() {
        return new Consumer<IDevice, Exception>(){

            public void consume(@Nullable IDevice device) throws Exception {
                Logcat.this._process = new AdbProcess(Logcat.this._id, "logcat", Logcat.this.getArguments(), device, null, (StreamListener<AdbProcess>)Logcat.this._streamListener, new Consumer<Exception, RuntimeException>(){

                    public void consume(@Nullable Exception e) {
                        if (Logcat.this.isLogTermination()) {
                            if (e != null) {
                                LOG.error("Logcat #" + Logcat.this.getId() + " exited with errors. Got: " + e.getMessage(), (Throwable)e);
                            } else {
                                LOG.info("Logcat #" + Logcat.this.getId() + " exited successful.");
                            }
                        }
                    }
                });
            }
        };
    }

    @Nonnull
    public File getAdbExecutable() {
        return this._adbExecutable;
    }

    @Nonnull
    public Predicate<IDevice> getDevicePredicate() {
        return this._devicePredicate;
    }

    @Nonnegative
    public Long getId() {
        return this._id;
    }

    @Nullable
    public AdbProcess getProcess() {
        return this._process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Logcat logcat = this;
        synchronized (logcat) {
            if (this._process != null) {
                try {
                    this._process.close();
                }
                finally {
                    this._process = null;
                }
            }
        }
    }

    @Nonnull
    public Logcat withArguments(@Nullable Iterable<String> arguments) {
        this._arguments = CollectionUtils.asImmutableList(arguments);
        return this.thisObject();
    }

    @Nonnull
    public Logcat withArguments(String ... arguments) {
        return this.withArguments(CollectionUtils.asImmutableList((Object[])arguments));
    }

    @Nonnull
    public Logcat withDeviceTimeout(@Nonnull Duration duration) {
        this._deviceTimeout = duration;
        return this.thisObject();
    }

    @Nonnull
    public Logcat withDeviceTimeout(@Nonnull String duration) {
        return this.withDeviceTimeout(new Duration(duration));
    }

    @Nonnull
    public Logcat withAdbTimeout(@Nonnull Duration duration) {
        this._adbTimeout = duration;
        return this.thisObject();
    }

    @Nonnull
    public Logcat withAdbTimeout(@Nonnull String duration) {
        return this.withAdbTimeout(new Duration(duration));
    }

    @Nonnull
    public Logcat withStreamListener(@Nonnull StreamListener<AdbProcess> streamListener) {
        this._streamListener = streamListener;
        return this.thisObject();
    }

    @Nonnull
    public Logcat withStreamListener(@Nonnull String streamListener) {
        return this.withStreamListener((StreamListener<AdbProcess>)StreamListeners.streamListenerFor(AdbProcess.class, (String)streamListener, Logcat.defaultStreamListener()));
    }

    @Nonnull
    public Logcat whichLogsStart(boolean log) {
        this._logStart = log;
        return this.thisObject();
    }

    @Nonnull
    public Logcat whichLogsStartupDone(boolean log) {
        this._logStartupDone = log;
        return this.thisObject();
    }

    @Nonnull
    public Logcat whichLogsTermination(boolean log) {
        this._logTermination = log;
        return this.thisObject();
    }

    @Nullable
    public List<String> getArguments() {
        return CollectionUtils.asImmutableList(this._arguments);
    }

    @Nonnull
    public StreamListener<?> getStreamListener() {
        return this._streamListener;
    }

    public boolean isLogStart() {
        return this._logStart;
    }

    public boolean isLogStartupDone() {
        return this._logStartupDone;
    }

    public boolean isLogTermination() {
        return this._logTermination;
    }

    @Nonnull
    public Duration getDeviceTimeout() {
        return this._deviceTimeout;
    }

    @Nonnull
    public Duration getAdbTimeout() {
        return this._adbTimeout;
    }

    @Nonnull
    protected Logcat thisObject() {
        return this;
    }

    @Nonnull
    protected static StreamListener<AdbProcess> defaultStreamListener() {
        return StreamListeners.redirectToLogger(Logcat.class);
    }
}

