/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.logcat;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.rundroid.maven.plugins.logcat.Logcat;
import org.echocat.rundroid.maven.plugins.utils.AdbMojoSupport;

public abstract class LogcatMojoSupport
extends AdbMojoSupport {
    @Nonnull
    private static final Map<Long, Logcat> ID_TO_LOGCAT = new ConcurrentHashMap<Long, Logcat>();
    @Parameter(property="logcat.pidProperty", defaultValue="logcat.pid")
    private String logcatPidProperty;

    @Nonnull
    protected String getLogcatPidProperty() throws MojoExecutionException {
        String result = this.logcatPidProperty;
        if (result == null) {
            throw new MojoExecutionException("No logcatPidProperty set.");
        }
        return result;
    }

    protected void registerLogcat(@Nonnull Logcat logcat) throws MojoExecutionException {
        ID_TO_LOGCAT.put(logcat.getId(), logcat);
    }

    protected void unregisterLogcat(@Nonnegative Logcat logcat) throws MojoExecutionException {
        ID_TO_LOGCAT.remove(logcat.getId());
    }

    @Nonnull
    protected Logcat findLogcat(@Nonnegative long id) throws MojoExecutionException {
        return ID_TO_LOGCAT.get(id);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown all left Logcats"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = ID_TO_LOGCAT;
                synchronized (map) {
                    ResourceUtils.closeQuietly(ID_TO_LOGCAT.values());
                }
            }
        });
    }
}

