/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.platform;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.ProcessUtils;
import org.echocat.jomon.process.listeners.stream.StreamListener;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.util.Consumer;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.rundroid.maven.plugins.platform.DeviceController;

public class AdbProcess
implements GeneratedProcess<String, Long> {
    @Nonnegative
    private final long _id;
    @Nonnull
    private final String _executable;
    @Nonnull
    private final List<String> _arguments;
    @Nonnull
    private final IDevice _device;
    @Nullable
    private final Duration _timeout;
    @Nonnull
    private final StreamListener<AdbProcess> _listener;
    @Nullable
    private final Consumer<Exception, RuntimeException> _callOnDone;
    @Nullable
    private volatile Thread _executionThread;
    @Nullable
    private volatile Exception _executionException;
    private volatile boolean _killed;

    public AdbProcess(@Nonnegative long id, @Nonnull String executable, @Nonnull Iterable<String> arguments, @Nonnull IDevice device, @Nullable Duration timeout, @Nonnull StreamListener<AdbProcess> listener) {
        this(id, executable, arguments, device, timeout, listener, null);
    }

    public AdbProcess(@Nonnegative long id, @Nonnull String executable, @Nonnull Iterable<String> arguments, @Nonnull IDevice device, @Nullable Duration timeout, @Nonnull StreamListener<AdbProcess> listener, @Nullable Consumer<Exception, RuntimeException> callOnDone) {
        this._id = id;
        this._executable = executable;
        this._device = device;
        this._timeout = timeout;
        this._listener = listener;
        this._callOnDone = callOnDone;
        this._arguments = CollectionUtils.asImmutableList(arguments);
        this._executionThread = this.start();
    }

    @Nonnull
    protected Thread start() {
        final DeviceController.Environment environment = DeviceController.Environment.deviceEnvironment(this._device).withCommandTimeout(this._timeout).withProgressConsumer(this.getOutputStreamOnListener());
        Thread thread = new Thread("Wait for " + this._executable + " on " + this._device.getSerialNumber()){

            @Override
            public void run() {
                try {
                    DeviceController.deviceController().exec(environment, ProcessUtils.toEscapedCommandLine((Object)AdbProcess.this._executable, (Iterable)AdbProcess.this._arguments), new Receiver());
                }
                catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
                    AdbProcess.this._executionException = (Exception)e;
                }
                finally {
                    AdbProcess.this._executionThread = null;
                    if (AdbProcess.this._callOnDone != null) {
                        AdbProcess.this._callOnDone.consume((Object)AdbProcess.this._executionException);
                    }
                }
            }
        };
        thread.start();
        return thread;
    }

    public int waitFor() throws InterruptedException {
        if (this._executionThread != null) {
            this._executionThread.join();
        }
        return this.exitValue();
    }

    public int exitValue() throws IllegalStateException {
        if (this.isAlive()) {
            throw new IllegalStateException("The process is still running.");
        }
        return this._executionException != null ? 1 : 0;
    }

    public boolean isAlive() {
        return this._executionThread != null && this._executionThread.isAlive();
    }

    public boolean isDaemon() {
        return false;
    }

    public void kill() throws IOException {
        this.close();
    }

    public void close() throws IOException {
        this._killed = true;
        try {
            this.waitFor();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    public String getExecutable() {
        return this._executable;
    }

    @Nullable
    public List<String> getArguments() {
        return this._arguments;
    }

    @Nullable
    public Long getId() {
        return this._id;
    }

    @Nonnull
    public OutputStream getStdin() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public InputStream getStdout() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public InputStream getStderr() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    protected OutputStream getOutputStreamOnListener() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                AdbProcess.this._listener.notifyOutput((GeneratedProcess)AdbProcess.this, b, len, len, StreamType.stdout);
            }

            @Override
            public void flush() throws IOException {
                AdbProcess.this._listener.flushOutput((GeneratedProcess)AdbProcess.this, StreamType.stdout);
            }
        };
    }

    protected class Receiver
    implements IShellOutputReceiver {
        protected Receiver() {
        }

        public void addOutput(byte[] data, int offset, int length) {
            AdbProcess.this._listener.notifyOutput((GeneratedProcess)AdbProcess.this, data, offset, length, StreamType.stdout);
        }

        public void flush() {
            AdbProcess.this._listener.flushOutput((GeneratedProcess)AdbProcess.this, StreamType.stdout);
        }

        public boolean isCancelled() {
            return AdbProcess.this._killed;
        }
    }
}

