/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.utils;

import com.android.ddmlib.IDevice;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.rundroid.maven.plugins.utils.IdentifierUtils;

public class DeviceUtils {
    @Nonnull
    public static String toString(@Nonnull IDevice device) {
        String model;
        String manufacturer;
        StringBuilder sb = new StringBuilder();
        sb.append(device.getSerialNumber());
        if (device.getAvdName() != null) {
            sb.append(':').append(device.getAvdName());
        }
        if (!StringUtils.isEmpty((CharSequence)(manufacturer = StringUtils.deleteWhitespace((String)device.getProperty("ro.product.manufacturer"))))) {
            sb.append(':').append(manufacturer);
        }
        if (!StringUtils.isEmpty((CharSequence)(model = StringUtils.deleteWhitespace((String)device.getProperty("ro.product.model"))))) {
            sb.append(':').append(model);
        }
        return sb.toString();
    }

    @Nonnull
    public static String toNormalizedString(@Nonnull IDevice device) {
        return IdentifierUtils.normalize(DeviceUtils.toString(device));
    }

    private DeviceUtils() {
    }

    @Nonnull
    public static Predicate<IDevice> deviceIsMatching(final @Nonnull String serialNumber) {
        return new Predicate<IDevice>(){

            public boolean apply(@Nullable IDevice input) {
                return input != null && input.isOnline() && serialNumber.equals(input.getSerialNumber());
            }
        };
    }
}

