/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.rundroid.maven.plugins.utils;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.echocat.rundroid.maven.plugins.utils.AdbMojoSupport;
import org.echocat.rundroid.maven.plugins.utils.ManifestUtils;

public abstract class ManifestAndAdbMojoSupport
extends AdbMojoSupport {
    @Parameter(property="android.manifestFile", defaultValue="${project.basedir}/AndroidManifest.xml")
    private File manifestFile;
    @Parameter(property="android.instrumentation.package")
    private String instrumentationPackage;

    @Nonnull
    protected String getInstrumentationPackage() throws MojoExecutionException {
        String result = this.instrumentationPackage;
        if (StringUtils.isEmpty((CharSequence)result)) {
            File file = this.findManifestFile();
            if (file == null) {
                throw new MojoExecutionException("Neither an instrumentationPackage was specified nor a manifestFile.");
            }
            result = ManifestUtils.getPackageNameFromAndroidManifest(file);
        }
        return result;
    }

    @Nullable
    protected File findManifestFile() throws MojoExecutionException {
        File file = this.manifestFile;
        if (file != null) {
            if (!file.exists()) {
                throw new MojoExecutionException("manifestFile " + file + " does not exist.");
            }
            if (!file.isFile()) {
                throw new MojoExecutionException("manifestFile " + file + " is  not a file.");
            }
        }
        return file;
    }
}

