/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven_efaps_jetty;

import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.efaps.init.StartupDatabaseConnection;
import org.efaps.init.StartupException;
import org.efaps.maven.logger.SLF4JOverMavenLog;
import org.efaps.maven_efaps_jetty.configuration.ServerDefinition;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Execute;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Goal;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Parameter;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.lifecycle.Phase;

@Goal(name="run", requiresDependencyResolutionScope="compile", requiresDirectInvocation=true)
@Execute(phase=Phase.INSTALL)
public class JettyRunMojo
implements Mojo {
    @Parameter(defaultValue="8888")
    private int port;
    @Parameter(defaultValue="127.0.0.1")
    private String host;
    @Parameter(required=true)
    private String jaasConfigFile;
    @Parameter(required=true)
    private String configFile;
    @Parameter(required=true, expression="${org.efaps.db.factory}")
    private String factory;
    @Parameter(expression="${org.efaps.db.connection}", required=true)
    private String connection;
    @Parameter(expression="${org.efaps.db.type}", required=true)
    private String type;
    @Parameter(expression="${org.efaps.transaction.timeout}", required=false)
    private String transactionTimeout;
    @Parameter(expression="${org.efaps.transaction.manager}", defaultValue="org.objectweb.jotm.Current", required=true)
    private String transactionManager;
    private Log log = null;

    public void execute() throws MojoExecutionException {
        this.init();
        Server server = new Server();
        this.getLog().info((CharSequence)("Starting jetty Version " + server.getClass().getPackage().getImplementationVersion()));
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setHost(this.host);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        System.setProperty("java.security.auth.login.config", this.jaasConfigFile);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)contexts, "/eFaps", 1);
        ServerDefinition serverDef = ServerDefinition.read(this.configFile);
        serverDef.updateServer(handler);
        try {
            this.getLog().info((CharSequence)"Starting Server");
            server.start();
            this.getLog().info((CharSequence)"Server Started");
            server.join();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not Start Jetty Server", e);
        }
    }

    protected void init() {
        try {
            Class.forName("org.efaps.maven.logger.SLF4JOverMavenLog");
            SLF4JOverMavenLog.LOGGER = this.getLog();
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"could not initialize SLF4J over maven logger");
        }
        try {
            StartupDatabaseConnection.startup((String)this.type, (String)this.factory, (String)this.connection, (String)this.transactionManager, this.transactionTimeout == null ? null : Integer.valueOf(Integer.parseInt(this.transactionTimeout)));
        }
        catch (StartupException e) {
            this.getLog().error((CharSequence)("Initialize Database Connection failed: " + e.toString()));
        }
    }

    public void setLog(Log _log) {
        this.log = _log;
    }

    public Log getLog() {
        return this.log;
    }
}

