/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven_efaps_jetty.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.efaps.maven_efaps_jetty.configuration.FilterDefinition;
import org.efaps.maven_efaps_jetty.configuration.ServletDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ServerDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(ServerDefinition.class);
    private final List<FilterDefinition> filters = new ArrayList<FilterDefinition>();
    private final List<ServletDefinition> servlets = new ArrayList<ServletDefinition>();

    public static ServerDefinition read(String _url) {
        ServerDefinition ret = null;
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.addObjectCreate("server", ServerDefinition.class);
            digester.addObjectCreate("server/filter", FilterDefinition.class);
            digester.addSetNext("server/filter", "addFilter");
            digester.addCallMethod("server/filter", "setName", 1);
            digester.addCallParam("server/filter", 0, "name");
            digester.addCallMethod("server/filter", "setClassName", 1);
            digester.addCallParam("server/filter", 0, "classname");
            digester.addCallMethod("server/filter", "setPathSpec", 1);
            digester.addCallParam("server/filter", 0, "path");
            digester.addCallMethod("server/filter/parameter", "addIniParam", 2);
            digester.addCallParam("server/filter/parameter", 0, "key");
            digester.addCallParam("server/filter/parameter", 1);
            digester.addObjectCreate("server/servlet", ServletDefinition.class);
            digester.addSetNext("server/servlet", "addServlet");
            digester.addCallMethod("server/servlet", "setName", 1);
            digester.addCallParam("server/servlet", 0, "name");
            digester.addCallMethod("server/servlet", "setClassName", 1);
            digester.addCallParam("server/servlet", 0, "classname");
            digester.addCallMethod("server/servlet", "setPathSpec", 1);
            digester.addCallParam("server/servlet", 0, "path");
            digester.addCallMethod("server/servlet", "setInitOrder", 1, new Class[]{Integer.class});
            digester.addCallParam("server/servlet", 0, "initorder");
            digester.addCallMethod("server/servlet/parameter", "addIniParam", 2);
            digester.addCallParam("server/servlet/parameter", 0, "key");
            digester.addCallParam("server/servlet/parameter", 1);
            ret = (ServerDefinition)digester.parse(_url);
        }
        catch (IOException e) {
            LOG.error(_url.toString() + " is not readable", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error(_url.toString() + " seems to be invalide XML", (Throwable)e);
        }
        return ret;
    }

    public void updateServer(ServletContextHandler _handler) {
        for (FilterDefinition filter : this.filters) {
            filter.updateServer(_handler);
        }
        for (ServletDefinition servlet : this.servlets) {
            servlet.updateServer(_handler);
        }
    }

    public void addFilter(FilterDefinition _filter) {
        this.filters.add(_filter);
    }

    public void addServlet(ServletDefinition _servlet) {
        this.servlets.add(_servlet);
    }
}

