/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.number2words.converters;

import java.text.DecimalFormat;
import org.efaps.number2words.IConverter;

public abstract class AbstractDecimalConverter
implements IConverter {
    private static final String FORMAT_MASK = "000000000000000000000";

    protected String convertLessThanOneThousand(int _number) {
        return this.getNumNames()[_number / 100] + ' ' + this.getTensNames()[_number < 100 ? 0 : 10] + ' ' + this.convertLessThanOneHundred(_number % 100);
    }

    protected abstract String convertLessThanOneHundred(int var1);

    protected abstract String[] getNumNames();

    protected abstract String[] getTensNames();

    protected abstract String[] getPowerNames();

    protected abstract String getZero();

    protected abstract String getMinus();

    protected String convertPower(int _number, int _power) {
        StringBuilder ret = new StringBuilder();
        if (_number != 0) {
            ret.append(this.convertLessThanOneThousand(_number)).append(' ').append(this.getPowerNames()[_power]);
        }
        return ret.toString();
    }

    public String convert(long _number) {
        StringBuilder ret = new StringBuilder();
        if (_number == 0L) {
            ret.append(this.getZero());
        } else {
            long number = _number < 0L ? _number * -1L : _number;
            DecimalFormat df = new DecimalFormat(FORMAT_MASK);
            String snumber = df.format(number);
            int quintillions = Integer.parseInt(snumber.substring(0, 3));
            int quadrillions = Integer.parseInt(snumber.substring(3, 6));
            int trillions = Integer.parseInt(snumber.substring(6, 9));
            int billions = Integer.parseInt(snumber.substring(9, 12));
            int millions = Integer.parseInt(snumber.substring(12, 15));
            int thousands = Integer.parseInt(snumber.substring(15, 18));
            int hundreds = Integer.parseInt(snumber.substring(18, 21));
            String result = this.convertPower(quintillions, 5) + ' ' + this.convertPower(quadrillions, 4) + ' ' + this.convertPower(trillions, 3) + ' ' + this.convertPower(billions, 2) + ' ' + this.convertPower(millions, 1) + ' ' + this.convertPower(thousands, 0) + ' ' + this.convertLessThanOneThousand(hundreds);
            if (_number < 0L) {
                ret.append(this.getMinus()).append(' ');
            }
            ret.append(result.replaceAll("^\\s+", "").replaceAll("\\b\\s{2,}\\b", " ").trim());
        }
        return ret.toString();
    }

    public boolean isDecimal() {
        return true;
    }

    public boolean usesShortScale() {
        return false;
    }
}

