/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.number2words.converters;

import org.efaps.number2words.converters.AbstractDecimalConverter;

public class German
extends AbstractDecimalConverter {
    private static final String[] NUM_NAMES = new String[]{"", "ein", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun", "zehn", "elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn"};
    private static final String[] TENS_NAMES = new String[]{"", "zehn", "zwanzig", "drei\u00dfig", "vierzig", "f\u00fcnfzig", "sechzig", "siebzig", "achtzig", "neunzig", "hundert"};
    private static final String[] POWER_NAMES = new String[]{"tausend", "Millionen", "Milliarden", "Billionen", "Billiarden", "Trillionen"};
    private static final String[] SINGLE_POWER_NAMES = new String[]{"ein tausend", "eine Million", "eine Milliarde", "eine Billion", "eine Billiarde", "eine Trillion"};

    protected String convertLessThanOneHundred(int _number) {
        StringBuilder ret = new StringBuilder();
        if (_number < 20) {
            ret.append(this.getNumNames()[_number]);
        } else {
            int modTen = _number % 10;
            if (modTen > 0) {
                ret.append(this.getNumNames()[_number % 10]).append("und");
            }
            ret.append(this.getTensNames()[_number / 10]);
        }
        return ret.toString();
    }

    protected String convertPower(int _number, int _power) {
        return _number == 1 ? SINGLE_POWER_NAMES[_power] : super.convertPower(_number, _power);
    }

    protected String[] getNumNames() {
        return NUM_NAMES;
    }

    protected String[] getTensNames() {
        return TENS_NAMES;
    }

    protected String[] getPowerNames() {
        return POWER_NAMES;
    }

    protected String getZero() {
        return "null";
    }

    protected String getMinus() {
        return "minus";
    }
}

