/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.number2words.converters;

import org.efaps.number2words.converters.AbstractDecimalConverter;

public class Spanish
extends AbstractDecimalConverter {
    private static final String[] NUM_NAMES = new String[]{"", "uno", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve", "diez", "once", "doce", "trece", "catorce", "quince", "diecis\u00e9is", "diecisiete", "dieciocho", "diecinueve", "veinte", "veintiuno", "veintid\u00f3s", "veintitr\u00e9s", "veinticuatro", "veinticinco", "veintis\u00e9is", "veintisiete", "veintiocho", "veintinueve"};
    private static final String[] TENS_NAMES = new String[]{"", "diez", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa", "ciento"};
    private static final String[] HUNDREDS_NAMES = new String[]{"", "ciento", "doscientos", "trescientos", "cuatrocientos", "quinientos", "seiscientos", "setecientos", "ochocientos", "novecientos"};
    private static final String[] POWER_NAMES = new String[]{"mil", "mill\u00f3nes", "mil mill\u00f3nes", "bill\u00f3nes", "mil bill\u00f3nes", "trill\u00f3nes"};
    private static final String[] SINGLE_POWER_NAMES = new String[]{"un mil", "un mill\u00f3n", "mil mill\u00f3nes", "un bill\u00f3n", "mil bill\u00f3nes", "un trill\u00f3n"};

    protected String convertLessThanOneThousand(int _number) {
        StringBuilder ret = new StringBuilder();
        if (_number == 100) {
            ret.append("cien");
        } else {
            ret.append(HUNDREDS_NAMES[_number / 100]).append(' ').append(this.convertLessThanOneHundred(_number % 100));
        }
        return ret.toString();
    }

    protected String convertLessThanOneHundred(int _number) {
        StringBuilder ret = new StringBuilder();
        if (_number < 30) {
            ret.append(" ").append(NUM_NAMES[_number]);
        } else {
            ret.append(" ").append(TENS_NAMES[_number / 10]);
            String num = NUM_NAMES[_number % 10];
            if (!"".equals(num)) {
                ret.append(" y ").append(NUM_NAMES[_number % 10]);
            }
        }
        return ret.toString();
    }

    protected String convertPower(int _number, int _power) {
        return _number == 1 ? SINGLE_POWER_NAMES[_power] : super.convertPower(_number, _power);
    }

    protected String[] getNumNames() {
        return NUM_NAMES;
    }

    protected String[] getTensNames() {
        return TENS_NAMES;
    }

    protected String[] getPowerNames() {
        return POWER_NAMES;
    }

    protected String getZero() {
        return "cero";
    }

    protected String getMinus() {
        return "menos";
    }
}

