/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.number2words.converters;

import org.efaps.number2words.converters.AbstractDecimalConverter;

public class English
extends AbstractDecimalConverter {
    private static final String[] NUM_NAMES = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] TENS_NAMES = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety", "hundred"};
    private static final String[] POWER_NAMES = new String[]{"thousand", "million", "billion", "trillion", "quadrillion", "quintillion"};

    protected String convertLessThanOneHundred(int _number) {
        StringBuilder ret = new StringBuilder();
        if (_number < 20) {
            ret.append(this.getNumNames()[_number]);
        } else {
            ret.append(this.getTensNames()[_number / 10]).append('-').append(this.getNumNames()[_number % 10]);
        }
        return ret.toString();
    }

    protected String[] getNumNames() {
        return NUM_NAMES;
    }

    protected String[] getTensNames() {
        return TENS_NAMES;
    }

    protected String[] getPowerNames() {
        return POWER_NAMES;
    }

    protected String getZero() {
        return "zero";
    }

    protected String getMinus() {
        return "minus";
    }

    public boolean usesShortScale() {
        return true;
    }
}

