/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.tenant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ThreadLocalSupplier<V>
implements Supplier<V>,
Consumer<V> {
    private static Map<Class<?>, ThreadLocalSupplier<?>> supplier = new ConcurrentHashMap();
    private final ThreadLocal<V> tl = new ThreadLocal();

    public static <V0> ThreadLocalSupplier<V0> supplyFor(Class<V0> clazz) {
        return supplier.computeIfAbsent(clazz, c -> new ThreadLocalSupplier());
    }

    private ThreadLocalSupplier() {
    }

    @Override
    public V get() {
        return this.tl.get();
    }

    @Override
    public void accept(V val) {
        this.tl.set(val);
    }

    public void reset() {
        this.tl.remove();
    }
}

