/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.audit.msg;

import java.util.Set;

public class AuditMsg {
    private final String query;
    private final String queryId;
    private final String location;
    private final Object[] ehrIds;
    private final Integer version;
    private final String templateId;
    private final String directoryId;
    private final String compositionId;
    private final String contributionId;
    private final Set<String> removedPatients;
    private final Boolean isQueryExecuteEndpoint;

    private AuditMsg(Builder builder) {
        this.query = builder.query;
        this.ehrIds = builder.ehrIds;
        this.queryId = builder.queryId;
        this.version = builder.version;
        this.location = builder.location;
        this.templateId = builder.templateId;
        this.compositionId = builder.compositionId;
        this.contributionId = builder.contributionId;
        this.removedPatients = builder.removedPatients;
        this.isQueryExecuteEndpoint = builder.isQueryExecuteEndpoint;
        this.directoryId = builder.directoryId;
    }

    public String getLocation() {
        return this.location;
    }

    public Object[] getEhrIds() {
        return this.ehrIds;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getQuery() {
        return this.query;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getCompositionId() {
        return this.compositionId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getContributionId() {
        return this.contributionId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public Set<String> getRemovedPatients() {
        return this.removedPatients;
    }

    public Boolean getIsQueryExecuteEndpoint() {
        return this.isQueryExecuteEndpoint;
    }

    static class Builder {
        private String location;
        private Object[] ehrIds;
        private Integer version;
        private String query;
        private String queryId;
        private String compositionId;
        private String directoryId;
        private String templateId;
        private String contributionId;
        private Set<String> removedPatients;
        private Boolean isQueryExecuteEndpoint;

        Builder() {
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder ehrIds(Object ... ehrIds) {
            this.ehrIds = ehrIds;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public Builder compositionId(String compositionId) {
            this.compositionId = compositionId;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder contributionId(String contributionId) {
            this.contributionId = contributionId;
            return this;
        }

        public Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public Builder removedPatients(Set<String> removedPatients) {
            this.removedPatients = removedPatients;
            return this;
        }

        public Builder isQueryExecuteEndpoint(Boolean isQueryExecuteEndpoint) {
            this.isQueryExecuteEndpoint = isQueryExecuteEndpoint;
            return this;
        }

        public AuditMsg build() {
            return new AuditMsg(this);
        }
    }
}

