/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.service;

import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.VersionedComposition;
import com.nedap.archie.rm.generic.RevisionHistory;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.service.BaseService;
import org.ehrbase.api.service.VersionedObjectService;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionDto;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.CompositionFormat;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.StructuredString;

public interface CompositionService
extends BaseService,
VersionedObjectService<Composition, UUID> {
    public Optional<Composition> retrieve(UUID var1, UUID var2, Integer var3);

    public static CompositionDto from(UUID ehrId, Composition composition) {
        return new CompositionDto(composition, composition.getArchetypeDetails().getTemplateId().getValue(), UUID.fromString(composition.getUid().getRoot().getValue()), ehrId);
    }

    public StructuredString serialize(CompositionDto var1, CompositionFormat var2);

    public Integer getLastVersionNumber(UUID var1);

    public String getTemplateIdFromInputComposition(String var1, CompositionFormat var2);

    public String retrieveTemplateId(UUID var1);

    public Integer getVersionByTimestamp(UUID var1, LocalDateTime var2);

    public boolean exists(UUID var1);

    public boolean isDeleted(UUID var1);

    public void adminDelete(UUID var1);

    public VersionedComposition getVersionedComposition(UUID var1, UUID var2);

    public RevisionHistory getRevisionHistoryOfVersionedComposition(UUID var1, UUID var2);

    public Optional<OriginalVersion<Composition>> getOriginalVersionComposition(UUID var1, UUID var2, int var3);

    public Composition buildComposition(String var1, CompositionFormat var2, String var3);

    public UUID getEhrId(UUID var1);
}

