/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.service;

import java.util.EnumSet;
import java.util.List;

public interface TerminologyServer<T, ID, U> {
    public List<T> expand(ID var1);

    public List<T> expandWithParameters(ID var1, U ... var2);

    public T lookUp(ID var1);

    public Boolean validate(T var1, ID var2);

    public Boolean validate(U ... var1);

    public SubsumptionResult subsumes(T var1, T var2);

    public static enum TerminologyAdapter {
        FHIR("hl7.org/fhir/R4"),
        OCEAN("OTS.OCEANHEALTHSYSTEMS.COM"),
        BETTER("bts.better.care"),
        DTS4("dts4.apelon.com"),
        INDIZEN("cts2.indizen.com");

        private String adapterId;
        private static EnumSet<TerminologyAdapter> supportedAdapters;

        public String getAdapterId() {
            return this.adapterId;
        }

        private TerminologyAdapter(String adapterId) {
            this.adapterId = adapterId;
        }

        public static boolean isAdapterSupported(String adapterToCheck) {
            for (TerminologyAdapter ta : supportedAdapters) {
                if (!ta.name().equals(adapterToCheck)) continue;
                return true;
            }
            return false;
        }

        static {
            supportedAdapters = EnumSet.of(FHIR);
        }
    }

    public static enum SubsumptionResult {
        EQUIVALENT,
        SUBSUMES,
        SUBSUMEDBY,
        NOTSUBSUMED;

    }
}

