/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.service;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.generic.AuditDetails;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.openehr.sdk.response.dto.ehrscape.ContributionDto;

public interface ContributionService {
    @Nonnull
    public ContributionDto getContribution(UUID var1, UUID var2);

    public UUID commitContribution(UUID var1, String var2);

    public void adminDelete(UUID var1, UUID var2);

    public static enum ContributionChangeType {
        CREATION(249),
        AMENDMENT(250),
        MODIFICATION(251),
        SYNTHESIS(252),
        UNKNOWN(253),
        DELETED(523);

        final int code;

        private ContributionChangeType(int code) {
            this.code = code;
        }

        public static ContributionChangeType fromAuditDetails(AuditDetails commitAudit) {
            DvCodedText changeType = commitAudit.getChangeType();
            if (!"openehr".equals(changeType.getDefiningCode().getTerminologyId().getValue())) {
                throw new ValidationException("Unsupported change type terminology: %s".formatted(changeType.getDefiningCode().getTerminologyId().getValue()));
            }
            ContributionChangeType byCode = ContributionChangeType.getByCode(changeType.getDefiningCode().getCodeString());
            if (byCode.name().equalsIgnoreCase(changeType.getValue())) {
                return byCode;
            }
            throw new ValidationException("Inconsistent change type: %s for code %s".formatted(changeType.getValue(), changeType.getDefiningCode().getCodeString()));
        }

        private static ContributionChangeType getByCode(String codeString) {
            int code;
            try {
                code = Integer.parseInt(codeString);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Unknown change type code %s".formatted(codeString));
            }
            return Stream.of(ContributionChangeType.values()).filter(t -> t.code == code).findFirst().orElseThrow(() -> new ValidationException("Unknown change type code %s".formatted(codeString)));
        }

        public int getCode() {
            return this.code;
        }
    }
}

