/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.dto;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record AqlQueryRequest(@Nonnull String queryString, @Nullable Map<String, Object> parameters, @Nullable Long fetch, @Nullable Long offset) {
    public AqlQueryRequest(@Nonnull String queryString, @Nullable Map<String, Object> parameters, @Nullable Long fetch, @Nullable Long offset) {
        this.queryString = queryString;
        this.parameters = AqlQueryRequest.rewriteExplicitParameterTypes(parameters);
        this.fetch = fetch;
        this.offset = offset;
    }

    public static Map<String, Object> rewriteExplicitParameterTypes(Map<String, Object> parameters) {
        if (parameters == null) {
            return Map.of();
        }
        parameters.entrySet().forEach(e -> {
            Object nv;
            Object ov = e.getValue();
            if (ov != (nv = AqlQueryRequest.handleExplicitParameterTypes(ov))) {
                e.setValue(nv);
            }
        });
        return parameters;
    }

    private static Object handleExplicitParameterTypes(Object paramValue) {
        Object result;
        if (paramValue instanceof Map) {
            Map m = (Map)((Object)paramValue);
            Object object = m.get("type");
            if (object instanceof String) {
                String type = (String)object;
                result = switch (type) {
                    case "int" -> AqlQueryRequest.intValue(m, "").orElse(paramValue);
                    case "num" -> AqlQueryRequest.numValue(m, "").orElse(paramValue);
                    default -> AqlQueryRequest.handleExplicitParameterTypes(m.get(""));
                };
            } else {
                List children;
                object = m.get("");
                result = object instanceof List && !(children = (List)object).isEmpty() ? children.stream().map(AqlQueryRequest::handleExplicitParameterTypes).toList() : AqlQueryRequest.intValue(m, "int").orElseGet(() -> AqlQueryRequest.numValue(m, "num").orElse(paramValue));
            }
        } else if (paramValue instanceof List) {
            List l = paramValue;
            int s = l.size();
            for (int i = 0; i < s; ++i) {
                Object n;
                Object v = l.get(i);
                if (v == (n = AqlQueryRequest.handleExplicitParameterTypes(v))) continue;
                l.set(i, n);
            }
            result = paramValue;
        } else {
            result = paramValue;
        }
        return result;
    }

    private static Optional<Object> intValue(Map<?, ?> paramValues, String key) {
        return Optional.of(key).map(paramValues::get).map(Object::toString).map(Integer::parseInt);
    }

    private static Optional<Object> numValue(Map<?, ?> paramValues, String key) {
        return Optional.of(key).map(paramValues::get).map(Object::toString).map(Double::parseDouble);
    }
}

