/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.dto;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;

public record AqlQueryRequest(@Nonnull AqlQuery aqlQuery, @Nullable Map<String, Object> parameters, @Nullable Long fetch, @Nullable Long offset) {
    public static AqlQueryRequest prepare(@Nonnull String queryString, @Nullable Map<String, Object> parameters, @Nullable Long fetch, @Nullable Long offset) {
        try {
            AqlQuery aqlQuery = AqlQueryParser.parse((String)queryString);
            return new AqlQueryRequest(aqlQuery, parameters, fetch, offset);
        }
        catch (AqlParseException e) {
            throw new IllegalAqlException("Could not parse AQL query: " + Optional.of(e).map(Throwable::getCause).orElse(e).getMessage(), e);
        }
    }
}

