/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.api.dto;

import java.util.Map;
import java.util.Optional;
import org.ehrbase.api.exception.IllegalAqlException;
import org.ehrbase.openehr.sdk.aql.dto.AqlQuery;
import org.ehrbase.openehr.sdk.aql.parser.AqlParseException;
import org.ehrbase.openehr.sdk.aql.parser.AqlQueryParser;

public record AqlQueryRequest(String aqlString, AqlQuery aqlQuery, Map<String, Object> parameters, Long fetch, Long offset) {
    public static AqlQueryRequest prepare(String queryString, Map<String, Object> parameters, Long fetch, Long offset) {
        try {
            AqlQuery aqlQuery = AqlQueryParser.parse((String)queryString);
            return new AqlQueryRequest(queryString, aqlQuery, parameters, fetch, offset);
        }
        catch (AqlParseException e) {
            throw new IllegalAqlException("Could not parse AQL query: " + Optional.of(e).map(Throwable::getCause).orElse(e).getMessage(), e);
        }
    }
}

